/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004  Alexander Dymo <cloudtemple@mskat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "linestyleedit.h"
#include "editoritem.h"

#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqcombobox.h>
#include <tqlayout.h>
#include <tqvariant.h>

using namespace KoProperty;

    //! @internal
    static const char *nopen[]={
    "48 16 1 1",
    ". c None",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    //! @internal
    static const char *solid[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".###########################################....",
    ".###########################################....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    //! @internal
    static const char *dash[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".#########..#########..#########..##########....",
    ".#########..#########..#########..##########....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    //! @internal
    static const char *dashdot[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".#########..##..#########..##..#########..##....",
    ".#########..##..#########..##..#########..##....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};
    //! @internal
    static const char *dashdotdot[]={
    "48 16 2 1",
    ". c None",
    "# c #000000",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    ".#########..##..##..#########..##..##..#####....",
    ".#########..##..##..#########..##..##..#####....",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................",
    "................................................"};


LineStyleEdit::LineStyleEdit(Property *property, TQWidget *parent, const char *name)
 : Widget(property, parent, name)
{
	TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
	m_edit = new TQComboBox(this);
	m_edit->setSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding);
	m_edit->setMinimumHeight(5);
	l->addWidget(m_edit);

	m_edit->insertItem(TQPixmap(nopen));
	m_edit->insertItem(TQPixmap(solid));
	m_edit->insertItem(TQPixmap(dash));
	m_edit->insertItem(TQPixmap(dashdot));
	m_edit->insertItem(TQPixmap(dashdotdot));

	setLeavesTheSpaceForRevertButton(true);
	setFocusWidget(m_edit);
	connect(m_edit, TQT_SIGNAL(activated(int)), this, TQT_SLOT(slotValueChanged(int)));
}

LineStyleEdit::~LineStyleEdit()
{}

TQVariant
LineStyleEdit::value() const
{
	return m_edit->currentItem();
}

void
LineStyleEdit::setValue(const TQVariant &value, bool emitChange)
{
	if (!value.canCast(TQVariant::Int))
		return;
	if ((value.toInt() > 5) || (value.toInt() < 0))
		return;

	m_edit->blockSignals(true);
	m_edit->setCurrentItem(value.toInt());
	m_edit->blockSignals(false);
	if (emitChange)
		emit valueChanged(this);
}

void
LineStyleEdit::drawViewer(TQPainter *p, const TQColorGroup &, const TQRect &r, const TQVariant &value)
{
	p->eraseRect(r);

	if (!value.canCast(TQVariant::Int))
		return;

	TQPixmap px;
	switch (value.toInt()) {
	case 0:
		px = TQPixmap(nopen);
		break;
	case 1:
		px = TQPixmap(solid);
		break;
	case 2:
		px = TQPixmap(dash);
		break;
	case 3:
		px = TQPixmap(dashdot);
		break;
	case 4:
		px = TQPixmap(dashdotdot);
		break;
	default:
		return;
	}
	p->drawPixmap(r.left()+KPROPEDITOR_ITEM_MARGIN, r.top()+(r.height()-px.height())/2, px);
}

void
LineStyleEdit::slotValueChanged(int)
{
	emit valueChanged(this);
}

void
LineStyleEdit::setReadOnlyInternal(bool readOnly)
{
	setVisibleFlag(!readOnly);
}

#include "linestyleedit.moc"
