/*
 * Copyright (c) 2004 Sven Langkamp <longamp@reallygood.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KO_COLORWHEEL_H
#define KO_COLORWHEEL_H

#include <tqpixmap.h>

#include <tdeselect.h>
#include <koColor.h>

class TQPainter;

class KoColorWheel : public KXYSelector
{
  Q_OBJECT
  

public:
    KoColorWheel( TQWidget *parent=0, const char *name=0 );

signals:
    void valueChanged(const KoColor& c);

public slots:
    virtual void slotSetValue(const KoColor& c);

protected:
    virtual void drawWheel( TQPixmap *pixmap );
    virtual void resizeEvent( TQResizeEvent * );
    virtual void mousePressEvent( TQMouseEvent *e );
    virtual void mouseMoveEvent( TQMouseEvent *e );
    virtual void drawContents( TQPainter *painter );

private:
    TQPixmap m_pixmap;
    KoColor m_color;
};

#endif
