/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef webpresentation_h
#define webpresentation_h

#include <kwizard.h>

#include <tqdialog.h>
#include <tqvaluelist.h>


class KPrDocument;
class KPrView;

class KURLRequester;
class KColorButton;
class TDEListView;
class KIntNumInput;
class KLineEdit;
class KComboBox;

class TQVBox;
class TQHBox;

class TQListViewItem;
class TQCloseEvent;
class KProgress;
class TQLabel;

class TQCheckBox;

class KPrWebPresentation
{
public:

    KPrWebPresentation( KPrDocument *_doc, KPrView *_view );
    KPrWebPresentation( const TQString &_config, KPrDocument *_doc, KPrView *_view );
    KPrWebPresentation( const KPrWebPresentation &webPres );

    void setAuthor( const TQString &_author )
        { author = _author; }
    void setEMail( const TQString &_email )
        { email = _email; }
    void setTitle( const TQString &_title )
        { title = _title; }
    void setBackColor( const TQColor &_backColor )
        { backColor = _backColor; }
    void setTitleColor( const TQColor &_titleColor )
        { titleColor = _titleColor; }
    void setTextColor( const TQColor &_textColor )
        { textColor = _textColor; }
    void setXML( bool _xml )
        { xml = _xml; }
    void setWriteHeader( bool _writeHeader )
        { m_bWriteHeader = _writeHeader; }
    void setWriteFooter( bool _writeFooter )
        { m_bWriteFooter = _writeFooter; }
    void setLoopSlides( bool _loopSlides )
        { m_bLoopSlides = _loopSlides; }
    void setPath( const TQString &_path )
        { path = _path; }
    void setZoom( int _zoom )
        { zoom = _zoom; }
    void setTimeBetweenSlides( int _timeBetweenSlides )
        { timeBetweenSlides = _timeBetweenSlides; } // PAU
    void setEncoding( const TQString &_encoding ) { m_encoding = _encoding; }

    TQString getAuthor() const { return author; }
    TQString getEmail() const { return email; }
    TQString getTitle() const { return title; }
    TQColor getBackColor() const { return backColor; }
    TQColor getTitleColor() const { return titleColor; }
    TQColor getTextColor() const { return textColor; }
    bool isXML() const { return xml; }
    bool wantHeader() const { return m_bWriteHeader; }
    bool wantFooter() const { return m_bWriteFooter; }
    bool wantLoopSlides() const { return m_bLoopSlides; }
    TQString getPath() const { return path; }
    int getZoom() const { return zoom; }
    int getTimeBetweenSlides() const { return timeBetweenSlides; } // PAU
    TQString getEncoding() const { return m_encoding; }

    struct SlideInfo {
        int pageNumber; /* 0-based */
        TQString slideTitle;
    };
    // Each entry in this list is a page (number+title).
    // This allows to skip pages.
    TQValueList<SlideInfo> getSlideInfos() const { return slideInfos; }

    void setSlideTitle( int i, const TQString &slideTitle )
        { slideInfos[i].slideTitle = slideTitle; }

    void setConfig( const TQString &_config )
        { config = _config; }
    TQString getConfig() const { return config; }

    void loadConfig();
    void saveConfig();

    int initSteps() const { return 7; }
    int slides1Steps() { return slideInfos.count(); }
    int slides2Steps() { return slideInfos.count(); }
    int mainSteps() const { return 1; }

    void initCreation( KProgress *progressBar );
    void createSlidesPictures( KProgress *progressBar );
    void createSlidesHTML( KProgress *progressBar );
    void createMainPage( KProgress *progressBar );

protected:
    void init();
    TQString escapeHtmlText( TQTextCodec *codec, const TQString& strText ) const;
    void writeStartOfHeader(TQTextStream& streamOut, TQTextCodec *codec,
                            const TQString& subtitle, const TQString& dest );

    KPrDocument *doc;
    KPrView *view;
    TQString config;
    TQString author, title, email;
    TQValueList<SlideInfo> slideInfos;
    TQColor backColor, titleColor, textColor;
    TQString path;    
    bool xml;
    bool m_bWriteHeader, m_bWriteFooter, m_bLoopSlides;
    int timeBetweenSlides;
    int zoom;
    TQString m_encoding;
};

class KPrWebPresentationWizard : public KWizard
{
    Q_OBJECT
  

public:
    KPrWebPresentationWizard( const TQString &_config, KPrDocument *_doc, KPrView *_view );
    ~KPrWebPresentationWizard();

    static void createWebPresentation( const TQString &_config, KPrDocument *_doc, KPrView *_view );

protected:

    void setupPage1();
    void setupPage2();
    void setupPage3();
    void setupPage4();
    void setupPage5(); // PAU

    void closeEvent( TQCloseEvent *e );

    TQString config;
    KPrDocument *doc;
    KPrView *view;
    KPrWebPresentation webPres;

    TQHBox *page1, *page2, *page3, *page4, *page5; // PAU
    TQCheckBox *writeHeader, *writeFooter, *loopSlides; // PAU
    KLineEdit *author, *title, *email;
    KColorButton *textColor, *titleColor, *backColor;
    KComboBox *encoding, *doctype;
    KIntNumInput *zoom, *timeBetweenSlides; // PAU
    KURLRequester *path;
    TDEListView *slideTitles;
    KLineEdit *slideTitle;

protected slots:
    virtual void finish();
    void pageChanged();
    void slotChoosePath(const TQString &);
    void slideTitleChanged( const TQString & );
    void slideTitleChanged( TQListViewItem * );

};

class KPrWebPresentationCreateDialog : public TQDialog
{
    Q_OBJECT
  

public:
    KPrWebPresentationCreateDialog( KPrDocument *_doc, KPrView *_view, const KPrWebPresentation &_webPres );
    ~KPrWebPresentationCreateDialog();

    static void createWebPresentation( KPrDocument *_doc, KPrView *_view, const KPrWebPresentation &_webPres );

    void start();

    void initCreation();
    void createSlidesPictures();
    void createSlidesHTML();
    void createMainPage();

protected:
    void setupGUI();
    void resizeEvent( TQResizeEvent *e );

    KPrView *view;
    KPrDocument *doc;
    KPrWebPresentation webPres;

    KProgress *progressBar;
    TQLabel *step1, *step2, *step3, *step4, *step5;    
    TQPushButton *bDone, *bSave;
    TQVBox *back;

protected slots:
    void saveConfig();

};
#endif
