/* This file is part of the KDE project
   Copyright (C) 2005 Thorsten Zachmann <zachmann@kde.org>
   based on work by
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef RECTPREVIEW_H
#define RECTPREVIEW_H

#include <tqframe.h>
#include <tqpen.h>
#include <tqbrush.h>

class KPrRectPreview : public TQFrame
{
    Q_OBJECT
  

public:
    KPrRectPreview( TQWidget* parent, const char* );
    ~KPrRectPreview() {}

    void setRnds( int _rx, int _ry )
        { xRnd = _rx; yRnd = _ry; repaint( contentsRect(), true ); }
    void setPenBrush( const TQPen &_pen, const TQBrush &_brush )
        { pen = _pen; brush = _brush; repaint( true ); }

protected:
    void drawContents( TQPainter* );

    int xRnd, yRnd;
    TQPen pen;
    TQBrush brush;
};

#endif /* RECTPREVIEW_H */
