/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef BACKDIA_H
#define BACKDIA_H

#include <kdialogbase.h>
#include <tqframe.h>
#include <tqdatetime.h>

#include "global.h"
#include "KPrBackground.h"

#include <KoBrush.h>
#include <KoPicture.h>

class TQLabel;
class TQComboBox;
class KColorButton;
class TQSlider;
class KPrBackGround;
class TQCheckBox;
class TQTabWidget;
class KPrPage;
class KURLRequester;


class KPrBackPreview : public TQFrame
{
    Q_OBJECT
  

public:
    KPrBackPreview( TQWidget *parent, KPrPage *page );
    virtual ~KPrBackPreview();

    KPrBackGround *backGround() const {
        return back;
    }

protected:
    virtual void drawContents( TQPainter *p );

private:
    KPrBackGround *back;

};

class KPrBackDialog : public KDialogBase
{
    Q_OBJECT
  

public:
    KPrBackDialog( TQWidget* parent, const char* name,
             BackType backType, const TQColor &backColor1,
             const TQColor &backColor2, BCType _bcType,
             const KoPicture &backPic,
             BackView backPicView, bool _unbalanced,
             int _xfactor, int _yfactor, KPrPage *_page  );

    KPrBackGround::Settings getBackGround() const;
    bool useMasterBackground() const;

protected:
    void showEvent( TQShowEvent *e );
    TQColor getBackColor1() const;
    TQColor getBackColor2() const;
    BCType getBackColorType() const;
    BackType getBackType() const;
    KoPicture getBackPicture() const { return m_picture; }
    BackView getBackView() const;
    bool getBackUnbalanced() const;
    int getBackXFactor() const;
    int getBackYFactor() const;
private:
    TQLabel *picPreview;
    TQCheckBox *unbalanced;
    TQComboBox *cType, *backCombo, *picView;
    TQLabel *picChooseLabel;
    KURLRequester *picChoose;
    KColorButton *color1Choose, *color2Choose;
    TQSlider *xfactor, *yfactor;
    KPrBackPreview *preview;
    bool picChanged, lockUpdate;
    TQLabel *labXFactor, *labYFactor;
    TQTabWidget *tabWidget;
    TQCheckBox *m_useMasterBackground;

    bool oldUseMasterBackground;
    BackType oldBackType;
    TQColor oldBackColor1;
    TQColor oldBackColor2;
    BCType oldBcType;
    BackView oldBackPicView;
    bool oldUnbalanced;
    int oldXFactor;
    int oldYFactor;

    KoPicture m_picture, m_oldpicture;
    KPrPage *m_page;

private slots:
    void aboutToSelectPic();
    void afterSelectPic( const TQString & );
    void updateConfiguration();

    void Ok() { emit backOk( this, false ); }
    void Apply() { emit backOk( this, false ); }
    void ApplyGlobal() { emit backOk( this, true ); }

    void changeComboText(int _p);
    void slotReset();

signals:
    void backOk( KPrBackDialog*, bool );

};
#endif //BACKDIA_H
