/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2005 Peter Simonsson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "mousetoolaction.h"

#include <tdetoolbar.h>
#include <tdetoolbarbutton.h>
#include <kdebug.h>

namespace Kivio {

MouseToolAction::MouseToolAction(const TQString& text, const TDEShortcut& cut,
                            TQObject* parent, const char* name)
  : TDERadioAction(text, cut, parent, name)
{
}

MouseToolAction::MouseToolAction(const TQString& text, const TDEShortcut& cut,
                            const TQObject* receiver, const char* slot,
                            TQObject* parent, const char* name)
  : TDERadioAction(text, cut, receiver, slot, parent, name)
{
}

MouseToolAction::MouseToolAction(const TQString& text, const TQIconSet& pix,
                            const TDEShortcut& cut,
                            TQObject* parent, const char* name)
  : TDERadioAction(text, pix, cut, parent, name)
{
}

MouseToolAction::MouseToolAction(const TQString& text, const TQString& pix,
                            const TDEShortcut& cut,
                            TQObject* parent, const char* name)
  : TDERadioAction(text, pix, cut, parent, name)
{
}

MouseToolAction::MouseToolAction(const TQString& text, const TQIconSet& pix,
                            const TDEShortcut& cut,
                            const TQObject* receiver, const char* slot,
                            TQObject* parent, const char* name)
  : TDERadioAction(text, pix, cut, receiver, slot, parent, name)
{
}

MouseToolAction::MouseToolAction(const TQString& text, const TQString& pix,
                            const TDEShortcut& cut,
                            const TQObject* receiver, const char* slot,
                            TQObject* parent, const char* name)
  : TDERadioAction(text, pix, cut, receiver, slot, parent, name)
{
}

MouseToolAction::MouseToolAction(TQObject* parent, const char* name)
  : TDERadioAction(parent, name)
{
}

MouseToolAction::~MouseToolAction()
{
}

int MouseToolAction::plug(TQWidget* widget, int index)
{
  int usedIndex = TDERadioAction::plug(widget, index);
  
  if(usedIndex == -1) {
    return usedIndex;
  }
  
  if(::tqqt_cast<TDEToolBar*>(widget)) {
    TDEToolBar* toolBar = static_cast<TDEToolBar*>(widget);
    TDEToolBarButton* button = toolBar->getButton(itemId(usedIndex));
    connect(button, TQT_SIGNAL(doubleClicked(int)), this, TQT_SIGNAL(doubleClicked()));
  }
  
  return usedIndex;
}

}

#include "mousetoolaction.moc"
