/* This file is part of the KDE project
   Copyright (C) 2002   Lucijan Busch <lucijan@gmx.at>
   Copyright (C) 2003-2004, 2006 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIRELATIONVIEW_H
#define KEXIRELATIONVIEW_H

#include <tqguardedptr.h>
#include <tqscrollview.h>
#include <tqptrlist.h>
#include <tqdict.h>

#include <kexidb/tableschema.h>

#include "kexirelationviewconnection.h"

class TQFrame;

class KexiRelationViewTable;
class KexiRelationViewTableContainer;
class TDEAction;
class TDEPopupMenu;

namespace KexiDB
{
	class Reference;
	class Connection;
}

typedef TQDict<KexiRelationViewTableContainer> TablesDict;
typedef TQDictIterator<KexiRelationViewTableContainer> TablesDictIterator;
typedef TQPtrList<KexiRelationViewConnection> ConnectionList;
typedef TQPtrListIterator<KexiRelationViewConnection> ConnectionListIterator;

struct SourceConnection
{
	TQString masterTable;
	TQString detailsTable;
	TQString masterField;
	TQString detailsField;
};

/*! @short provides a view for displaying relations between database tables.

 It is currently used for two purposes:
 - displaying global database relations
 - displaying relations defined for a database query

 The class is for displaying only - retrieving data and updating data on the backend side is implemented 
 in KexiRelationWidget, and more specifically in: Kexi Relation Part and Kexi Query Part.
*/
class KEXIRELATIONSVIEW_EXPORT KexiRelationView : public TQScrollView
{
	Q_OBJECT
  

	public:
		KexiRelationView(TQWidget *parent, const char *name=0);
		virtual ~KexiRelationView();

		//! \return a dictionary of added tables
		TablesDict* tables() { return &m_tables; }

		/*! Adds a table \a t to the area. This changes only visual representation.
		 If \a rect is valid, table widget geometry will be initialized.
		 \return added table container or 0 on failure.
		 */
		KexiRelationViewTableContainer* addTableContainer(KexiDB::TableSchema *t, 
			const TQRect &rect = TQRect());

		/*! \return table container for table \a t. */
		KexiRelationViewTableContainer * tableContainer(KexiDB::TableSchema *t) const;

		//! Adds a connection \a con to the area. This changes only visual representation.
		void addConnection(const SourceConnection& _conn /*, bool interactive=true*/);

		void setReadOnly(bool);

		inline KexiRelationViewConnection* selectedConnection() const { return m_selectedConnection; }

		inline KexiRelationViewTableContainer* focusedTableView() const { return m_focusedTableView; }

		virtual TQSize sizeHint() const;

		const ConnectionList* connections() const { return &m_connectionViews; }

//		KexiRelationViewTableContainer* containerForTable(KexiDB::TableSchema* tableSchema);

	signals:
		void tableContextMenuRequest( const TQPoint& pos );
		void connectionContextMenuRequest( const TQPoint& pos );
		void emptyAreaContextMenuRequest( const TQPoint& pos );
		void tableViewGotFocus();
		void connectionViewGotFocus();
		void emptyAreaGotFocus();
		void tableHidden(KexiDB::TableSchema& t);
		void tablePositionChanged(KexiRelationViewTableContainer*);
		void aboutConnectionRemove(KexiRelationViewConnection*);

	public slots:
		//! Clears current selection - table/query or connection
		void clearSelection();

		/*! Removes all tables and connections from the view. 
		 Does not emit signals like tableHidden(). */
		void clear();

		/*! Removes all coonections from the view. */
		void removeAllConnections();

		/*! Hides all tables except \a tables. */
		void hideAllTablesExcept( KexiDB::TableSchema::List* tables );

		void slotTableScrolling(const TQString&);

		//! removes selected table or connection
		void removeSelectedObject();


	protected slots:
		void containerMoved(KexiRelationViewTableContainer *c);
		void slotListUpdate(TQObject *s);
		void slotTableViewEndDrag();
		void slotTableViewGotFocus();

	protected:
//		/*! executes popup menu at \a pos, or, 
//		 if \a pos not specified: at center of selected table view (if any selected),
//		 or at center point of the relations view. */
//		void executePopup( TQPoint pos = TQPoint(-1,-1) );

		void drawContents(TQPainter *p, int cx, int cy, int cw, int ch);
		void contentsMousePressEvent(TQMouseEvent *ev);
		virtual void keyPressEvent(TQKeyEvent *ev);

		void recalculateSize(int width, int height);
		void stretchExpandSize();
//		void		invalidateActions();
//		void clearTableSelection();
//		void clearConnSelection();

		void hideTable(KexiRelationViewTableContainer* tableView);
		void removeConnection(KexiRelationViewConnection *conn);

		TablesDict m_tables;
		bool m_readOnly;
		ConnectionList m_connectionViews;
		KexiRelationViewConnection* m_selectedConnection;
		TQGuardedPtr<KexiRelationViewTableContainer> m_focusedTableView;
};

#endif
