/* This file is part of the KDE project
   Copyright (C) 2004 Lucijan Busch <lucijan@kde.org>
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2005-2007 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/
#ifndef KEXIDBFORM_H
#define KEXIDBFORM_H

#include <tqpixmap.h>

#include <formeditor/form.h>
#include "../kexiformdataiteminterface.h"

#ifdef KEXI_USE_GRADIENT_WIDGET
#include <kexigradientwidget.h>
# define KexiDBFormBase KexiGradientWidget
#else
# define KexiDBFormBase TQWidget
#endif

class KexiDataAwareObjectInterface;
class KexiFormScrollView;

//! @short A DB-aware form widget, acting as form's toplevel widget
class KEXIFORMUTILS_EXPORT KexiDBForm : 
	public KexiDBFormBase,
	public KFormDesigner::FormWidget,
	public KexiFormDataItemInterface
{
	Q_OBJECT
  
	TQ_PROPERTY(TQString dataSource READ dataSource WRITE setDataSource DESIGNABLE true)
	TQ_PROPERTY(TQCString dataSourceMimeType READ dataSourceMimeType WRITE setDataSourceMimeType DESIGNABLE true)
	TQ_PROPERTY(bool autoTabStops READ autoTabStops WRITE setAutoTabStops DESIGNABLE true)
	//original "size" property is not designable, so here's a custom (not storable) replacement
	TQ_PROPERTY( TQSize sizeInternal READ sizeInternal WRITE resizeInternal DESIGNABLE true STORED false )
	public:
		KexiDBForm(TQWidget *parent, KexiDataAwareObjectInterface* dataAwareObject, const char *name="kexi_dbform");
		virtual ~KexiDBForm();

		KexiDataAwareObjectInterface* dataAwareObject() const;

		inline TQString dataSource() const { return KexiFormDataItemInterface::dataSource(); }
		inline TQCString dataSourceMimeType() const { return KexiFormDataItemInterface::dataSourceMimeType(); }

		//! no effect
		TQVariant value() { return TQVariant(); }

		virtual void setInvalidState( const TQString& displayText );

		virtual void drawRect(const TQRect& r, int type);
		virtual void drawRects(const TQValueList<TQRect> &list, int type);
		virtual void initBuffer();
		virtual void clearForm();
		virtual void highlightWidgets(TQWidget *from, TQWidget *to/*, const TQPoint &p*/);

		virtual TQSize sizeHint() const;

		bool autoTabStops() const;

		TQPtrList<TQWidget>* orderedFocusWidgets() const;

		TQPtrList<TQWidget>* orderedDataAwareWidgets() const;
		
		void updateTabStopsOrder(KFormDesigner::Form* form);

		void updateTabStopsOrder();

		virtual bool eventFilter ( TQObject * watched, TQEvent * e );

		virtual bool valueIsNull();
		virtual bool valueIsEmpty();
		virtual bool isReadOnly() const;
		virtual TQWidget* widget();
		virtual bool cursorAtStart();
		virtual bool cursorAtEnd();
		virtual void clear();

		bool preview() const;

		virtual void setCursor( const TQCursor & cursor );

	public slots:
		void setAutoTabStops(bool set);
		inline void setDataSource(const TQString &ds) { KexiFormDataItemInterface::setDataSource(ds); }
		inline void setDataSourceMimeType(const TQCString &ds) { KexiFormDataItemInterface::setDataSourceMimeType(ds); }

		//! This implementation just disables read only widget
		virtual void setReadOnly( bool readOnly );

		//! @internal for sizeInternal property
		TQSize sizeInternal() const { return KexiDBFormBase::size(); }

		//! @internal for sizeInternal property
		void resizeInternal(const TQSize& s) { KexiDBFormBase::resize(s); }

	signals:
		void handleDragMoveEvent(TQDragMoveEvent *e);
		void handleDropEvent(TQDropEvent *e);

	protected:
		//! no effect
		virtual void setValueInternal(const TQVariant&, bool) {}

		//! Used to emit handleDragMoveEvent() signal needed to control dragging over the container's surface
		virtual void dragMoveEvent( TQDragMoveEvent *e );

		//! Used to emit handleDropEvent() signal needed to control dropping on the container's surface
		virtual void dropEvent( TQDropEvent *e );

		//! called from KexiFormScrollView::initDataContents()
		void updateReadOnlyFlags();
//		virtual void paintEvent( TQPaintEvent * );

		//! Points to a currently edited data item. 
		//! It is cleared when the focus is moved to other 
		KexiFormDataItemInterface *editedItem;

		class Private;
		Private *d;

		friend class KexiFormScrollView;
};

#endif
