#ifndef KDCHARTAXISPARAMSWRAPPER_H
#define KDCHARTAXISPARAMSWRAPPER_H
#include <tqobject.h>
#include <KDChartEnums.h>
#include <KDChartAxisParams.h>
#include <tqstringlist.h>
#include <tqvariant.h>
class KDChartAxisParams;

class KDChartAxisParamsWrapper :public TQObject
{
    Q_OBJECT
  

public:
    KDChartAxisParamsWrapper( KDChartAxisParams* );

public slots:
    // These overload are only for convenience.
    void setAxisValueStart( double axisValueStart );
    void setAxisValueEnd( double axisValueEnd );
    void setAxisValueStart( const TQVariant axisValueStart );
    void setAxisValueEnd( const TQVariant axisValueEnd );

public slots:
    void setAxisValues( bool axisSteadyValueCalc = true,
                        TQVariant axisValueStart = KDCHART_AXIS_LABELS_AUTO_LIMIT,
                        TQVariant axisValueEnd = KDCHART_AXIS_LABELS_AUTO_LIMIT,
                        double axisValueDelta = KDCHART_AXIS_LABELS_AUTO_DELTA,
                        int axisDigitsBehindComma = KDCHART_AXIS_LABELS_AUTO_DIGITS,
                        int axisMaxEmptyInnerSpan = KDCHART_DONT_CHANGE_EMPTY_INNER_SPAN_NOW,
                        int takeLabelsFromDataRow = KDChartAxisParams::LabelsFromDataRowNo,
                        int labelTextsDataRow = 0,
                        const TQVariant& axisLabelStringList = TQVariant( TQStringList() ),
                        const TQVariant& axisShortLabelsStringList = TQVariant( TQStringList() ),
                        int axisValueLeaveOut = KDCHART_AXIS_LABELS_AUTO_LEAVEOUT,
                        int axisValueDeltaScale = KDChartAxisParams::ValueScaleNumerical );

    void setAxisLabelStringLists( const TQVariant& axisLabelStringList,
                                  const TQVariant& axisShortLabelStringList,
                                  const TQString& valueStart = TQString(),
                                  const TQString& valueEnd   = TQString() );

    void setAxisLabelTexts( const TQVariant& axisLabelTexts );
private:
    KDChartAxisParams* _data;
};


#endif /* KDCHARTAXISPARAMSWRAPPER_H */

