#ifndef _kchartWIZARDSETUPAXESPAGE_H
#define _kchartWIZARDSETUPAXESPAGE_H

#include <tqwidget.h>
#include <kcolorbutton.h>

class TQColor;
class TQLineEdit;
class TQSpinBox;
class TQPushButton;
class TQCheckBox;

namespace KChart
{

class KChartPart;
class kchartWidget;

class KChartWizardSetupAxesPage : public TQWidget
{
  Q_OBJECT
  

public:
  KChartWizardSetupAxesPage( TQWidget* parent, KChartPart* chart );
  ~KChartWizardSetupAxesPage();
  bool chart3d;
public slots:
      void apply();
      void changeLabelColor(const TQColor &);
      void changeLabelFont();
      void changeBorderColor(const TQColor &);
      void changeGridColor(const TQColor &);
protected:
      void paintEvent( TQPaintEvent *_ev );

private:
  kchartWidget* preview;
  KChartPart* _chart;
  TQCheckBox* gridX;
  TQCheckBox* gridY;
  TQCheckBox* border;
  TQLineEdit *y_interval;
  TQLineEdit *y_max;
  TQLineEdit *y_min;
  TQLineEdit *ylabel_fmt;
#if 0
  TQLineEdit *ylabel2_fmt;
#endif
  TQSpinBox *angle;
  TQSpinBox *depth;
  TQSpinBox *barWidth;
  TQPushButton *ylabelFont;
  KColorButton *borderColor;
  KColorButton *gridColor;
  KColorButton *ylabelColor;
  TQFont ylabel;
  TQColor ycolor;
  TQColor colorGrid;
  TQColor colorBorder;
};

}  //namespace KChart

#endif
