/* This file is part of the KDE project
   Copyright (C) 2001, 2002, 2003 The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef _VGRADIENTWIDGET_H_
#define _VGRADIENTWIDGET_H_

#include <tqwidget.h>
#include <koffice_export.h>
class VGradient;
class TQPainter;
class VColor;

class KARBONBASE_EXPORT VGradientWidget : public TQWidget
{
	Q_OBJECT
  

public:
	VGradientWidget( VGradient& gradient, TQWidget* parent = 0L, const char* name = 0L );
	~VGradientWidget();

	virtual void paintEvent( TQPaintEvent* );

signals:
	void changed();

protected:
	/** mouse events... For color stops manipulation */
	void mousePressEvent( TQMouseEvent* );
	void mouseReleaseEvent( TQMouseEvent* );
	void mouseDoubleClickEvent( TQMouseEvent* );
	void mouseMoveEvent( TQMouseEvent* );

	void paintColorStop( TQPainter& p, int x, VColor& color );
	void paintMidPoint( TQPainter& p, int x );

	/** The gradient to modify. */
	VGradient*             m_gradient;
	/** The point to modify. */
	unsigned int currentPoint;
	
	TQRect m_pntArea;
}; // VGradientWidget

#endif /* _VGRADIENTWIDGET_H_ */
