/* This file is part of the KDE project
   Copyright (C) 2001, 2002, 2003 The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __KARBON_VIEW__
#define __KARBON_VIEW__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <KoView.h>
#include <KoPoint.h>
#include <ksharedptr.h>
#include <kxmlguibuilder.h>
#include <kdualcolorbutton.h>
#include <KoUnit.h>
#include <koffice_export.h>
class DCOPObject;
class TQLabel;

class TDEAction;
class KarbonPart;
class TDESelectAction;
class TDEToggleAction;
class KoContextHelpAction;
class KoLineStyleAction;

class KoUnitDoubleSpinComboBox;
class KoRect;
class VRuler;

class KoPaletteManager;
class VDocumentTab;
class VLayersTab;
class VHistoryTab;
class VStrokeDocker;
class VColorDocker;
class VStyleDocker;
class VTransformDocker;

class VFill;
class VPainterFactory;
class VSelectToolBar;
class VSmallPreview;
class VStateButton;
class VStroke;
class VStrokeFillPreview;
class VCanvas;
class VStrokeFillPreview;
class VTypeButtonBox;

class VTool;
class VToolBox;
class VToolController;

class VCommand;

class KARBONCOMMON_EXPORT KarbonView : public KoView, public KXMLGUIBuilder
{
	Q_OBJECT
  

public:
	KarbonView( KarbonPart* part, TQWidget* parent = 0L,
				const char* name = 0L );
	virtual ~KarbonView();

	virtual DCOPObject* dcopObject();

	KarbonPart *part() const { return m_part; }

	virtual void paintEverything( TQPainter &p, const TQRect &rect, bool transparent = false );

	bool mouseEvent( TQMouseEvent* event, const KoPoint & );
	bool keyEvent( TQEvent* event );
	void dropEvent( TQDropEvent *e );

	virtual TQWidget* canvas() const;

	VCanvas* canvasWidget() const { return m_canvas; }

	virtual VPainterFactory* painterFactory() const { return m_painterFactory; }

	KoPaletteManager* paletteManager() { return m_pPaletteManager; };

	// printing support, override from KoView
	virtual void setupPrinter( KPrinter &/*printer*/ ) {}
	virtual void print( KPrinter& printer );

	KoContextHelpAction* contextHelpAction() const { return m_contextHelpAction; }

	void reorganizeGUI();
	void setNumberOfRecentFiles( unsigned int number );
	void setLineWidth( double val );

	TQLabel* statusMessage() const { return m_status; }

	void setCursor( const TQCursor & );

	void repaintAll( const KoRect & );
	void repaintAll( bool = true );

	void setPos( const KoPoint& p );

	void setViewportRect( const KoRect &rect );
	void setZoomAt( double zoom, const KoPoint & = KoPoint() );

	VToolController *toolController();

	VStrokeFillPreview* strokeFillPreview()
		{ return m_strokeFillPreview; }

public slots:
	// editing:
	void editCut();
	void editCopy();
	void editPaste();
	void editSelectAll();
	void editDeselectAll();
	void editDeleteSelection();
	void editPurgeHistory();

	void selectionDuplicate();
	void selectionBringToFront();
	void selectionSendToBack();
	void selectionMoveUp();
	void selectionMoveDown();
	void selectionAlignHorizontalLeft();
	void selectionAlignHorizontalCenter();
	void selectionAlignHorizontalRight();
	void selectionAlignVerticalTop();
	void selectionAlignVerticalCenter();
	void selectionAlignVerticalBottom();

	void selectionDistributeHorizontalCenter();
	void selectionDistributeHorizontalGap();
	void selectionDistributeHorizontalLeft();
	void selectionDistributeHorizontalRight();
	void selectionDistributeVerticalCenter();
	void selectionDistributeVerticalGap();
	void selectionDistributeVerticalBottom();
	void selectionDistributeVerticalTop();

	void fileImportGraphic();

	void groupSelection();
	void ungroupSelection();

	void closePath();

	//View:
	void viewZoomIn();
	void viewZoomOut();

	void setUnit( KoUnit::Unit _unit );

	void configure();

	void pageLayout();

	void setLineWidth();
	void selectionChanged();

	void slotActiveToolChanged( VTool * );

	void togglePageMargins(bool);
	void showRuler();
	void showGrid();
	bool showPageMargins();
	void snapToGrid();

	void showSelectionPopupMenu( const TQPoint &pos );

protected slots:
	// Object related operations.

	// View.
	void viewModeChanged();
	void zoomChanged( const KoPoint & = KoPoint() );
	void setLineStyle( int );

	// Toolbox dialogs.
	void slotStrokeChanged( const VStroke& );
	void slotFillChanged( const VFill & );

	void canvasContentsMoving( int x, int y );
	void commandExecuted( VCommand *command );
	void strokeFillSelectionChanged( KDualColorButton::DualColor s );
	void colorChanged( const TQColor &c );
signals:
	void zoomChanged( double );
	void selectionChange();
	void pageLayoutChanged();

protected:
	virtual void updateReadWrite( bool ) {}
	virtual void resizeEvent( TQResizeEvent* event );

	void createDocumentTabDock();
	void createLayersTabDock();
	void createHistoryTabDock();
	void createStrokeDock();
	void createColorDock();
	void createTransformDock();
	void createResourceDock();

	//KXMLGUIBuilder
	virtual TQWidget *createContainer( TQWidget *parent, int index, const TQDomElement &element, int &id );
	virtual void removeContainer( TQWidget *container, TQWidget *parent, TQDomElement &element, int id );
	void addSelectionToClipboard() const;

private:
	void initActions();
	void updateRuler();

	KarbonPart		*m_part;
	VCanvas			*m_canvas;
	VRuler			*m_horizRuler;
	VRuler			*m_vertRuler;

	VPainterFactory		*m_painterFactory;
	VStrokeFillPreview	*m_strokeFillPreview;
	VTypeButtonBox		*m_typeButtonBox;

	VToolBox		*m_toolbox;

	TDEAction			*m_groupObjects;
	TDEAction			*m_ungroupObjects;

	TDEAction			*m_closePath;

	// actions:
	TDESelectAction		*m_zoomAction;
	TDESelectAction		*m_viewAction;
	TDEAction				*m_configureAction;
	TDEToggleAction		*m_showRulerAction;
	TDEToggleAction		*m_showGridAction;
	TDEToggleAction		*m_snapGridAction;
	TDEToggleAction		*m_showPageMargins;
	KoContextHelpAction	*m_contextHelpAction;
	TDEAction				*m_deleteSelectionAction;
	// line width
	KoUnitDoubleSpinComboBox *m_setLineWidth;
	KoLineStyleAction	*m_lineStyleAction;

	//dockers
	KoPaletteManager	*m_pPaletteManager;
	VDocumentTab		*m_DocumentTab;
	VLayersTab			*m_LayersTab;
	VHistoryTab			*m_HistoryTab;
	VColorDocker		*m_ColorManager;
	VStrokeDocker		*m_strokeDocker;
	VStyleDocker		*m_styleDocker;
	VTransformDocker	*m_TransformDocker;

	VSelectToolBar		*m_selectToolBar;

	// dcop
	DCOPObject		*m_dcop;

	//Status Bar
	TQLabel				*m_status;       // Ordinary status
	TQLabel				*m_cursorCoords; // Cursor coordinates
	VSmallPreview		*m_smallPreview; // Stroke and Fill
	VToolController	*m_toolController;
};

#endif

