/* This file is part of the KDE project
   Copyright (C) 2001, 2002, 2003 The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KARBON_DRAG_H
#define KARBON_DRAG_H

#include <tqdragobject.h>

#include "vgroup.h"

class VDocument;

#define NumEncodeFmts 1
#define NumDecodeFmts 1

class KarbonDrag : public TQDragObject
{
	Q_OBJECT
  
public:
	KarbonDrag( TQWidget* dragSource = 0, const char* name = 0 );
	const char* format( int i ) const;
	TQByteArray encodedData( const char* mimetype ) const;
	static bool canDecode( TQMimeSource * );
	static bool decode( TQMimeSource* e, VObjectList& sl, VDocument& vdoc );
	void setObjectList( VObjectList l );

private:
	static TQCString m_encodeFormats[NumEncodeFmts];
	static TQCString m_decodeFormats[NumDecodeFmts];
	VObjectList m_objects;
};

#endif

