
#ifndef _FILTER_KWORD_1_3__KWORDPARAGRAPH_H
#define _FILTER_KWORD_1_3__KWORDPARAGRAPH_H

#include <tqstring.h>
#include <tqvaluelist.h>
#include <tqptrlist.h>

#include "kword13layout.h"

class KWord13Format;

/**
 * A paragraph
 */
class KWord13Paragraph
{
public:
    KWord13Paragraph( void );
    ~KWord13Paragraph( void );
public:
    void xmldump( TQTextStream& iostream );
    void setText( const TQString& str);
    void appendText( const TQString& str);
    TQString text( void ) const;
public:
    /// \<LAYOUT\>
    KWord13Layout m_layout;
    /// \<FORMATS\>
    TQPtrList<KWord13Format> m_formats;
private:
    TQString m_text; ///< Text
};

/**
 * Group of paragraphs
 * (Mostly all paragraphs of a text frameset)
 */
class KWord13ParagraphGroup : public TQValueList <KWord13Paragraph>
{
public:
    void xmldump( TQTextStream& iostream );
};

#endif //  _FILTER_KWORD_1_3__KWORDPARAGRAPH_H
