/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 * Copyright (C) 2002 Patrick Julien <freak@codepimps.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#ifndef KIS_RULER_H_
#define KIS_RULER_H_

#include <tqframe.h>
#include <tqpixmap.h>
#include <KoUnit.h>

// XXX: Make this look more like the KOffice ruler -- the KOffice
// ruler is not quite suited to Chalk. Also: start units with 0,
// print every 100 units.

#define RULER_THICKNESS 20

class TQPainter;

class KisRuler : public TQFrame {
    Q_OBJECT
  
    typedef TQFrame super;

public:
    KisRuler(Qt::Orientation, TQWidget *parent = 0, const char *name = 0);
    virtual ~KisRuler();

public:
    KoUnit::Unit unit() const;

public slots:
    void setZoom(double zoom);
    void updatePointer(TQ_INT32 x, TQ_INT32 y);
    void updateVisibleArea(TQ_INT32 xpos, TQ_INT32 ypos);
    void setUnit(KoUnit::Unit u);
    void hide();
    void show();

protected:
    virtual void paintEvent(TQPaintEvent *e);
    virtual void resizeEvent(TQResizeEvent *e);
    virtual void styleChange(TQStyle& oldStyle);
    virtual void paletteChange(const TQPalette& oldPalette);

    void recalculateSize();
    void drawRuler();
    void initMarker(TQ_INT32 w, TQ_INT32 h);
    void drawNums(TQPainter *gc, TQ_INT32 x, TQ_INT32 y, TQString& num, bool orientationHoriz);

private:
    KoUnit::Unit m_unit;
    Qt::Orientation m_orientation;
    TQ_INT32 m_firstVisible;
    TQ_INT32 m_currentPosition;
    TQPixmap *m_pixmapBuffer;
    TQPixmap m_pixmapMarker;
    TQPixmap m_pixmapNums;
    double m_zoom;

private:
    static const char *m_nums[];
};

#endif // KIS_RULER_H_

