/*
 *  Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <stdio.h>
#include <stdlib.h>

#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqdrawutil.h>
#include <tqevent.h>
#include <tqfile.h>
#include <tqimage.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqvalidator.h>
#include <tqpainter.h>
#include <tqpushbutton.h>
#include <tqspinbox.h>
#include <tqtimer.h>

#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include <tdeglobalsettings.h>
#include <kiconloader.h>
#include <tdelistbox.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kseparator.h>
#include <kpalette.h>
#include <kimageeffect.h>

#include <kcolordialog.h>
#include <kcolordrag.h>
#include <config.h>
#include <kdebug.h>

#include <kis_meta_registry.h>
#include <kis_color.h>
#include <kis_factory.h>
#include <kis_colorspace_factory_registry.h>
#include "kis_palette_widget.h"
#include "kis_resource.h"
#include "kis_palette.h"
#include "kis_palette_view.h"

KisPaletteWidget::KisPaletteWidget( TQWidget *parent, int minWidth, int cols)
    : TQWidget( parent ), mMinWidth(minWidth), mCols(cols)
{
    init = false;

    m_currentPalette = 0;

    TQVBoxLayout *layout = new TQVBoxLayout( this );

    combo = new TQComboBox( false, this );
    combo->setFocusPolicy( TQ_ClickFocus );
    layout->addWidget(combo);

    m_view = new KisPaletteView(this, 0, minWidth, cols);
    layout->addWidget( m_view );

    //setFixedSize(sizeHint());

    connect(combo, TQT_SIGNAL(activated(const TQString &)),
            this, TQT_SLOT(slotSetPalette(const TQString &)));
    connect(m_view, TQT_SIGNAL(colorSelected(const KisColor &)),
            this, TQT_SIGNAL(colorSelected(const KisColor &)));
    connect(m_view, TQT_SIGNAL(colorSelected(const TQColor &)),
            this, TQT_SIGNAL(colorSelected(const TQColor &)));
    connect(m_view, TQT_SIGNAL(colorDoubleClicked(const KisColor &, const TQString &)),
            this, TQT_SIGNAL(colorDoubleClicked(const KisColor &, const TQString &)));
}

KisPaletteWidget::~KisPaletteWidget()
{
}

TQString KisPaletteWidget::palette() const
{
    return combo->currentText();
}


// 2000-02-12 Espen Sand
// Set the color in two steps. The setPalette() slot will not emit a signal
// with the current color setting. The reason is that setPalette() is used
// by the color selector dialog on startup. In the color selector dialog
// we normally want to display a startup color which we specify
// when the dialog is started. The slotSetPalette() slot below will
// set the palette and then use the information to emit a signal with the
// new color setting. It is only used by the combobox widget.
//
void KisPaletteWidget::slotSetPalette( const TQString &_paletteName )
{
    setPalette( _paletteName );
    m_view->slotColorCellSelected(0); // FIXME: We need to save the current value!!
}


void KisPaletteWidget::setPalette( const TQString &_paletteName )
{
    TQString paletteName( _paletteName);

    m_currentPalette = m_namedPaletteMap[paletteName];

    if (combo->currentText() != paletteName)
    {
        bool found = false;
        for(int i = 0; i < combo->count(); i++)
        {
            if (combo->text(i) == paletteName)
            {
                combo->setCurrentItem(i);
                found = true;
                break;
            }
        }
        if (!found)
        {
            combo->insertItem(paletteName);
            combo->setCurrentItem(combo->count()-1);
        }
    }

    m_view->setPalette(m_currentPalette);
}

void KisPaletteWidget::slotAddPalette(KisResource * palette)
{
    KisPalette * p = dynamic_cast<KisPalette*>(palette);

    m_namedPaletteMap.insert(palette->name(), p);

    combo->insertItem(palette->name());

    if (!init) {
        combo->setCurrentItem(0);
        setPalette(combo ->currentText());
        init = true;
    }
}


#include "kis_palette_widget.moc"

