/***************************************************************************
                          recording-monitor.h  -  description
                             -------------------
    begin                : Mo Sep 1 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_RECORDING_MONITOR_H
#define KRADIO_RECORDING_MONITOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqwidget.h>

#include "../../src/include/widgetplugins.h"
#include "../../src/include/soundstreamclient_interfaces.h"
//#include <tderadio/interfaces/recording-interfaces.h>


class TQLabel;
class TQPushButton;
class TQCheckBox;
class RecordingDataMonitor;
class KComboBox;

class RecordingMonitor : public TQWidget,
                         public WidgetPluginBase,
                         public ISoundStreamClient
                         //public IRecordingClient
{
Q_OBJECT
  
public:

    RecordingMonitor(const TQString &name);
    virtual ~RecordingMonitor();

    const TQString &name() const { return PluginBase::name(); }
          TQString &name()       { return PluginBase::name(); }

    virtual TQString pluginClassName() const { return "RecordingMonitor"; }

    // WidgetPluginBase

public:
    virtual void   saveState (TDEConfig *) const;
    virtual void   restoreState (TDEConfig *);

    virtual bool   connectI(Interface *i);
    virtual bool   disconnectI(Interface *i);

    virtual ConfigPageInfo  createConfigurationPage();
    virtual AboutPageInfo   createAboutPage();

    // IRecordingClient

    void noticeConnectedI (ISoundStreamServer *s, bool pointer_valid);

    bool noticeSoundStreamCreated(SoundStreamID id);
    bool noticeSoundStreamClosed(SoundStreamID id);
    bool noticeSoundStreamChanged(SoundStreamID id);

    bool startRecordingWithFormat(SoundStreamID id, const SoundFormat &sf, SoundFormat &real_format);
    bool stopRecording(SoundStreamID id);

    bool noticeSoundStreamData(SoundStreamID id, const SoundFormat &sf, const char *data, size_t size, size_t &consumed_size, const SoundMetaData &md);

public slots:

    void    toggleShown() { WidgetPluginBase::pToggleShown(); }
    void    showOnOrgDesktop();
    void    show();
    void    hide();

    void    slotStartStopRecording();

    void    slotStreamSelected(int idx);

protected:

    virtual void updateRecordingButton();

    virtual void showEvent(TQShowEvent *);
    virtual void hideEvent(TQHideEvent *);

    const TQWidget *getWidget() const { return this; }
          TQWidget *getWidget()       { return this; }


protected:

    TQLabel               *m_labelSize;
    TQLabel               *m_labelTime;
    TQLabel               *m_labelRate;
    TQLabel               *m_labelFileName;
    TQLabel               *m_labelStatus;
    TQPushButton          *m_btnStartStop;

    KComboBox               *m_comboSoundStreamSelector;
    TQMap<SoundStreamID, int> m_SoundStreamID2idx;
    TQMap<int, SoundStreamID> m_idx2SoundStreamID;

    SoundStreamID            m_currentStream;
    RecordingDataMonitor    *m_dataMonitor;

    bool                     m_recording;
    TQString                  m_defaultStreamDescription;
};




#endif
