/***************************************************************************
                          radioview-configuration.cpp  -  description
                             -------------------
    begin                : Fr Aug 15 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "radioview-configuration.h"
 
RadioViewConfiguration::RadioViewConfiguration(TQWidget *parent)
	: TQTabWidget (parent),
      m_dirty(true)
{
}

RadioViewConfiguration::~RadioViewConfiguration()
{
}


void RadioViewConfiguration::addTab    (TQWidget *child, const TQString &label)
{
	TQTabWidget::addTab(child, label);
	TQObject::connect(this,  TQT_SIGNAL(sigOK()),     child, TQT_SLOT(slotOK()));
	TQObject::connect(this,  TQT_SIGNAL(sigCancel()), child, TQT_SLOT(slotCancel()));
    TQObject::connect(child, TQT_SIGNAL(sigDirty()),  this,  TQT_SLOT(slotSetDirty()));
}


void RadioViewConfiguration::addTab    (TQWidget *child, const TQIconSet &iconset, const TQString &label)
{
	TQTabWidget::addTab(child, iconset, label);
	TQObject::connect(this,  TQT_SIGNAL(sigOK()),     child, TQT_SLOT(slotOK()));
	TQObject::connect(this,  TQT_SIGNAL(sigCancel()), child, TQT_SLOT(slotCancel()));
    TQObject::connect(child, TQT_SIGNAL(sigDirty()),  this,  TQT_SLOT(slotSetDirty()));
}


void RadioViewConfiguration::addTab    (TQWidget *child, TQTab *tab)
{
	TQTabWidget::addTab(child, tab);
	TQObject::connect(this,  TQT_SIGNAL(sigOK()),     child, TQT_SLOT(slotOK()));
	TQObject::connect(this,  TQT_SIGNAL(sigCancel()), child, TQT_SLOT(slotCancel()));
    TQObject::connect(child, TQT_SIGNAL(sigDirty()),  this,  TQT_SLOT(slotSetDirty()));
}


void RadioViewConfiguration::insertTab (TQWidget *child, const TQString &label, int index)
{
	TQTabWidget::insertTab(child, label, index);
	TQObject::connect(this,  TQT_SIGNAL(sigOK()),     child, TQT_SLOT(slotOK()));
	TQObject::connect(this,  TQT_SIGNAL(sigCancel()), child, TQT_SLOT(slotCancel()));
    TQObject::connect(child, TQT_SIGNAL(sigDirty()),  this,  TQT_SLOT(slotSetDirty()));
}


void RadioViewConfiguration::insertTab (TQWidget *child, const TQIconSet &iconset, const TQString &label, int index)
{
	TQTabWidget::insertTab(child, iconset, label, index);
	TQObject::connect(this,  TQT_SIGNAL(sigOK()),     child, TQT_SLOT(slotOK()));
	TQObject::connect(this,  TQT_SIGNAL(sigCancel()), child, TQT_SLOT(slotCancel()));
    TQObject::connect(child, TQT_SIGNAL(sigDirty()),  this,  TQT_SLOT(slotSetDirty()));
}


void RadioViewConfiguration::insertTab (TQWidget *child, TQTab *tab, int index)
{
	TQTabWidget::insertTab(child, tab, index);
	TQObject::connect(this,  TQT_SIGNAL(sigOK()),     child, TQT_SLOT(slotOK()));
	TQObject::connect(this,  TQT_SIGNAL(sigCancel()), child, TQT_SLOT(slotCancel()));
    TQObject::connect(child, TQT_SIGNAL(sigDirty()),  this,  TQT_SLOT(slotSetDirty()));
}


void RadioViewConfiguration::removePage(TQWidget *w)
{
	TQObject::disconnect(this,  TQT_SIGNAL(sigOK()),     w,    TQT_SLOT(slotOK()));
	TQObject::disconnect(this,  TQT_SIGNAL(sigCancel()), w,    TQT_SLOT(slotCancel()));
    TQObject::disconnect(w,     TQT_SIGNAL(sigDirty()),  this, TQT_SLOT(slotSetDirty()));
	TQTabWidget::removePage(w);
}


void RadioViewConfiguration::slotOK()
{
    if (m_dirty) {
        emit sigOK();
        m_dirty = false;
    }
}

void RadioViewConfiguration::slotCancel()
{
    if (m_dirty) {
        emit sigCancel();
        m_dirty = false;
    }
}

void RadioViewConfiguration::slotSetDirty()
{
    m_dirty = true;
}


#include "radioview-configuration.moc"
