/**
 * Copyright (C) 2003 Joonas Koivunen <rzei@mbnet.fi>
 * Copyright (C) 2003 Koos Vriezen <koos.vriezen@xs4all.nl>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _KMPlayerPREF_H_
#define _KMPlayerPREF_H_

#include "kmplayer_def.h"

#include <kdialogbase.h>
#include <tqframe.h>
#include <tqmap.h>

class TQTabWidget;
class TQTable;
class TQGroupBox;
class TQCheckBox;
class TQComboBox;
class TQLineEdit;
class TQRadioButton;
class TQSlider;
class TQSpinBox;
class TQColor;
class TQButtonGroup;
class KHistoryCombo;
class KComboBox;
class KURLRequester;
class KColorButton;

namespace KMPlayer {

class PrefGeneralPageGeneral; 	// general, general
class PrefSourcePageURL;        // source, url
class PrefRecordPage;           // recording
class RecorderPage;                     // base recorder
class PrefMEncoderPage;         // mencoder
class PrefMPlayerDumpstreamPage; // mplayer -dumpstream
class PrefFFMpegPage;           // ffmpeg
class PrefXinePage;             // xine url:record
class PrefGeneralPageLooks; 	// general, looks
class PrefGeneralPageOutput;	// general, output
class PrefOPPageGeneral;	// OP = outputplugins, general
class PrefOPPagePostProc;	// outputplugins, postproc
class PartBase;
class Source;
class Settings;
class PreferencesPage;
class OutputDriver;
class ColorSetting;
class FontSetting;

class KMPLAYER_NO_EXPORT Preferences : public KDialogBase
{
    Q_OBJECT
  
public:

    Preferences(PartBase *, Settings *);
    ~Preferences();

    PrefGeneralPageGeneral 	*m_GeneralPageGeneral;
    PrefSourcePageURL 		*m_SourcePageURL;
    PrefRecordPage 		*m_RecordPage;
    PrefMEncoderPage            *m_MEncoderPage;
    PrefMPlayerDumpstreamPage   *m_MPlayerDumpstreamPage;
#ifdef HAVE_XINE
    PrefXinePage                *m_XinePage;
#endif
    PrefFFMpegPage              *m_FFMpegPage;
    PrefGeneralPageLooks 	*m_GeneralPageLooks;
    PrefGeneralPageOutput 	*m_GeneralPageOutput;
    PrefOPPageGeneral 		*m_OPPageGeneral;
    PrefOPPagePostProc		*m_OPPagePostproc;
    void setDefaults();
    void setPage (const char *);
    void addPrefPage (PreferencesPage *);
    void removePrefPage (PreferencesPage *);

    RecorderPage * recorders;
    TQMap<TQString, TQTabWidget *> entries;
public slots:
    void confirmDefaults();
};

class KMPLAYER_NO_EXPORT PrefGeneralPageGeneral : public TQFrame
{
    Q_OBJECT
  
public:
    PrefGeneralPageGeneral(TQWidget *parent, Settings *);
    ~PrefGeneralPageGeneral() {}

    TQCheckBox *keepSizeRatio;
    TQCheckBox * autoResize;
    TQButtonGroup *sizesChoice;
    TQCheckBox *dockSysTray;
    TQCheckBox *loop;
    TQCheckBox *showConfigButton;
    TQCheckBox *showPlaylistButton;
    TQCheckBox *showRecordButton;
    TQCheckBox *showBroadcastButton;
    TQCheckBox *framedrop;
    TQCheckBox *adjustvolume;
    TQCheckBox *adjustcolors;

    TQSpinBox *seekTime;
};

class KMPLAYER_NO_EXPORT PrefGeneralPageLooks : public TQFrame {
    Q_OBJECT
  
public:
    PrefGeneralPageLooks (TQWidget *parent, Settings *);
    ~PrefGeneralPageLooks () {}
    TQComboBox *colorscombo;
    KColorButton *colorbutton;
    TQComboBox *fontscombo;
    TQPushButton *fontbutton;
public slots:
    void colorItemChanged (int);
    void colorCanged (const TQColor &);
    void fontItemChanged (int);
    void fontClicked ();
private:
    ColorSetting * colors;
    FontSetting * fonts;
};

class KMPLAYER_NO_EXPORT PrefSourcePageURL : public TQFrame
{
    Q_OBJECT
  
public:
    PrefSourcePageURL (TQWidget *parent);
    ~PrefSourcePageURL () {}

    KURLRequester * url;
    //KHistoryCombo * url;
    KComboBox * urllist;
    KURLRequester * sub_url;
    KComboBox * sub_urllist;
    TQListBox * backend;
    TQCheckBox * allowhref;
    TQLineEdit * prefBitRate;
    TQLineEdit * maxBitRate;
    bool changed;
private slots:
    void slotBrowse ();
    void slotTextChanged (const TQString &);
};


class KMPLAYER_NO_EXPORT PrefRecordPage : public TQFrame
{
    Q_OBJECT
  
public:
    PrefRecordPage (TQWidget *parent, PartBase *, RecorderPage *, int len);
    ~PrefRecordPage () {}

    KURLRequester * url;
    TQButtonGroup * recorder;
    TQButtonGroup * replay;
    TQLineEdit * replaytime;
    TQLabel * source;
public slots:
    void replayClicked (int id);
    void recorderClicked (int id);
private slots:
    void slotRecord ();
    void playingStopped ();
    void sourceChanged (KMPlayer::Source *, KMPlayer::Source *);
    void recordingStarted ();
    void recordingFinished ();
private:
    PartBase * m_player;
    RecorderPage * m_recorders;
    TQPushButton * recordButton;
    int m_recorders_length;
};

class KMPLAYER_NO_EXPORT RecorderPage : public TQFrame
{
    Q_OBJECT
  
public:
    RecorderPage (TQWidget *parent, PartBase *);
    virtual ~RecorderPage () {};
    virtual void record ();
    virtual TQString name () = 0;
    virtual const char * recorderName () = 0;
    RecorderPage * next;
protected:
    PartBase * m_player;
};

class KMPLAYER_NO_EXPORT PrefMEncoderPage : public RecorderPage 
{
    Q_OBJECT
  
public:
    PrefMEncoderPage (TQWidget *parent, PartBase *);
    ~PrefMEncoderPage () {}

    void record ();
    TQString name ();
    const char * recorderName () { return "mencoder"; }

    TQLineEdit * arguments;
    TQButtonGroup * format;
public slots:
    void formatClicked (int id);
private:
};

class KMPLAYER_NO_EXPORT PrefMPlayerDumpstreamPage : public RecorderPage {
public:
    PrefMPlayerDumpstreamPage (TQWidget *parent, PartBase *);
    ~PrefMPlayerDumpstreamPage () {}

    TQString name ();
    const char * recorderName () { return "mplayerdumpstream"; }
};

#ifdef HAVE_XINE
class KMPLAYER_NO_EXPORT PrefXinePage : public RecorderPage {
public:
    PrefXinePage (TQWidget *parent, PartBase *);
    ~PrefXinePage () {}

    TQString name ();
    const char * recorderName () { return "xine"; }
};
#endif

class KMPLAYER_NO_EXPORT PrefFFMpegPage : public RecorderPage
{
    Q_OBJECT
  
public:
    PrefFFMpegPage (TQWidget *parent, PartBase *);
    ~PrefFFMpegPage () {}

    void record ();
    TQString name ();
    const char * recorderName () { return "ffmpeg"; }

    TQLineEdit * arguments;
    TQButtonGroup * format;
private:
};


class KMPLAYER_NO_EXPORT PrefGeneralPageOutput : public TQFrame
{
    Q_OBJECT
  
public:
    PrefGeneralPageOutput (TQWidget *parent, OutputDriver * ad, OutputDriver * vd);
    ~PrefGeneralPageOutput() {}

    TQListBox *videoDriver;
    TQListBox *audioDriver;
};

class KMPLAYER_NO_EXPORT PrefOPPageGeneral : public TQFrame
{
    Q_OBJECT
  
public:
    PrefOPPageGeneral(TQWidget *parent = 0);
    ~PrefOPPageGeneral() {}
};

class KMPLAYER_NO_EXPORT PrefOPPagePostProc : public TQFrame
{
    Q_OBJECT
  
public:
    PrefOPPagePostProc(TQWidget *parent = 0);
    ~PrefOPPagePostProc() {}

    TQCheckBox* postProcessing;
    TQCheckBox* disablePPauto;
    TQTabWidget* PostprocessingOptions;

    TQRadioButton* defaultPreset;
    TQRadioButton* customPreset;
    TQRadioButton* fastPreset;

    TQCheckBox* HzDeblockFilter;
    TQCheckBox* VtDeblockFilter;
    TQCheckBox* DeringFilter;
    TQCheckBox* HzDeblockAQuality;
    TQCheckBox* VtDeblockAQuality;
    TQCheckBox* DeringAQuality;

    TQCheckBox* AutolevelsFilter;
    TQCheckBox* AutolevelsFullrange;
    TQCheckBox* HzDeblockCFiltering;
    TQCheckBox* VtDeblockCFiltering;
    TQCheckBox* DeringCFiltering;
    TQCheckBox* TmpNoiseFilter;
    TQSlider* TmpNoiseSlider;

    TQCheckBox* LinBlendDeinterlacer;
    TQCheckBox* CubicIntDeinterlacer;
    TQCheckBox* LinIntDeinterlacer;
    TQCheckBox* MedianDeinterlacer;
    TQCheckBox* FfmpegDeinterlacer;
};

} // namespace

#endif // _KMPlayerPREF_H_
