/**
 * Copyright (C) 2006 by Koos Vriezen <koos.vriezen@gmail.com>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef PLAYLISTVIEW_H
#define PLAYLISTVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdelistview.h>

#include "kmplayerplaylist.h"

class TQFont;
class TQPixmap;
class TQPainter;
class TQPopupMenu;
class TQDropEvent;

namespace KMPlayer {

class View;
class PlayListView;

bool isDragValid (TQDropEvent * de) KMPLAYER_NO_MBR_EXPORT;

/*
 * An item in the playlist
 */
class KMPLAYER_NO_EXPORT PlayListItem : public TQListViewItem {
public:
    PlayListItem (TQListViewItem *p, const NodePtr & e, PlayListView * lv);
    PlayListItem (TQListViewItem *p, const AttributePtr & e, PlayListView * lv);
    PlayListItem (PlayListView *v, const NodePtr & d, TQListViewItem * b);
    KDE_NO_CDTOR_EXPORT ~PlayListItem () {}
    void paintCell (TQPainter * p, const TQColorGroup & cg, int column, int width, int align);
    void paintBranches(TQPainter *p, const TQColorGroup &cg, int w, int y, int h);
    PlayListView * playListView () const;
    NodePtrW node;
    AttributePtrW m_attr;
    PlayListView * listview;
protected:
    PlayListItem (PlayListView *v, const NodePtr & e);
};

class KMPLAYER_NO_EXPORT RootPlayListItem : public PlayListItem {
public:
    RootPlayListItem (int id, PlayListView *v, const NodePtr & d, TQListViewItem * b, int flags);
    KDE_NO_CDTOR_EXPORT ~RootPlayListItem () {}
    void paintCell (TQPainter * p, const TQColorGroup & cg, int column, int width, int align);
    TQString source;
    TQString icon;
    int id;
    int flags;
    bool show_all_nodes;
    bool have_dark_nodes;
};

/*
 * The playlist GUI
 */
class KMPLAYER_EXPORT PlayListView : public TDEListView {
    Q_OBJECT
  
public:
    enum Flags {
        AllowDrops = 0x01, AllowDrag = 0x02,
        InPlaceEdit = 0x04, TreeEdit = 0x08,
        Moveable = 0x10, Deleteable = 0x20
    };
    PlayListView (TQWidget * parent, View * view, TDEActionCollection * ac);
    ~PlayListView ();
    void selectItem (const TQString & txt);
    void showAllNodes (RootPlayListItem *, bool show=true);
    void setActiveForegroundColor (const TQColor & c) { m_active_color = c; }
    const TQColor & activeColor () const { return m_active_color; }
    int addTree (NodePtr r, const TQString & src, const TQString & ico, int flgs);
    RootPlayListItem * rootItem (TQListViewItem * item) const;
    RootPlayListItem * rootItem (int id) const;
    void setFont (const TQFont &);
    PlayListItem * currentPlayListItem () const;
    PlayListItem * selectedPlayListItem () const;
    NodePtr lastDragNode () const { return m_last_drag; }
    int lastDragTreeId () const { return last_drag_tree_id; }
signals:
    void addBookMark (const TQString & title, const TQString & url);
    void prepareMenu (KMPlayer::PlayListItem * item, TQPopupMenu * menu);
protected:
    bool acceptDrag (TQDropEvent* event) const;
    TQDragObject * dragObject ();
public slots:
    void editCurrent ();
    void rename (TQListViewItem * item, int c);
    void updateTree (int id, NodePtr root, NodePtr active, bool sel, bool open);
private slots:
    void contextMenuItem (TQListViewItem *, const TQPoint &, int);
    void itemExpanded (TQListViewItem *);
    void copyToClipboard ();
    void addBookMark ();
    void toggleShowAllNodes ();
    void itemDropped (TQDropEvent * e, TQListViewItem * after);
    void itemIsRenamed (TQListViewItem * item);
    void itemIsSelected (TQListViewItem * item);
    void updateTrees ();
    void slotFind ();
    void slotFindOk ();
    void slotFindNext ();
private:
    void updateTree (RootPlayListItem * ritem, NodePtr active, bool select);
    PlayListItem * populate (NodePtr e, NodePtr focus, RootPlayListItem *root, PlayListItem * item, PlayListItem ** curitem);
    struct KMPLAYER_NO_EXPORT TreeUpdate {
        KDE_NO_CDTOR_EXPORT TreeUpdate (RootPlayListItem *ri, NodePtr n, bool s, bool o, SharedPtr <TreeUpdate> &nx) : root_item (ri), node (n), select (s), open (o), next (nx) {}
        KDE_NO_CDTOR_EXPORT ~TreeUpdate () {}
        RootPlayListItem * root_item;
        NodePtrW node;
        bool select;
        bool open;
        SharedPtr <TreeUpdate> next;
    };
    SharedPtr <TreeUpdate> tree_update;
    View * m_view;
    TQPopupMenu * m_itemmenu;
    TDEAction * m_find;
    TDEAction * m_find_next;
    KFindDialog * m_find_dialog;
    TQPixmap folder_pix;
    TQPixmap auxiliary_pix;
    TQPixmap video_pix;
    TQPixmap unknown_pix;
    TQPixmap menu_pix;
    TQPixmap config_pix;
    TQPixmap url_pix;
    TQPixmap info_pix;
    TQPixmap img_pix;
    TQColor m_active_color;
    NodePtrW m_current_find_elm;
    NodePtrW m_last_drag;
    AttributePtrW m_current_find_attr;
    int last_id;
    int last_drag_tree_id;
    int current_find_tree_id;
    bool m_ignore_expanded;
};

KDE_NO_EXPORT inline PlayListView * PlayListItem::playListView () const {
    return static_cast <PlayListView *> (listView ());
}

KDE_NO_EXPORT inline PlayListItem * PlayListView::currentPlayListItem () const {
    return static_cast <PlayListItem *> (currentItem ());
}

KDE_NO_EXPORT inline PlayListItem * PlayListView::selectedPlayListItem() const {
    return static_cast <PlayListItem *> (selectedItem ());
}

} // namespace

#endif // PLAYLISTVIEW_H
