/*
 * kaffeineaudioencoder.h
 *
 * Copyright (C) 2006 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef KAFFEINEAUDIOENCODER_H
#define KAFFEINEAUDIOENCODER_H

#include <tdeparts/part.h>
#include <tdeconfig.h>

#include <tqstring.h>
#include <tqwidget.h>

/*
 * Base-Class for Kaffeine audio encoder plugins.
 */

class KDE_EXPORT KaffeineAudioEncoder : public KParts::Part
{
	Q_OBJECT
  
public:
	KaffeineAudioEncoder(TQObject* parent, const char* name);
	virtual ~KaffeineAudioEncoder();

	// return false if the user's canceled.
	virtual bool options( TQWidget*, TDEConfig* ) {return false;}

	// your file extension, e.g. ".ogg"
	virtual TQString getExtension() {return TQString();}

	virtual void start( TQString/*title*/=0, TQString/*artist*/=0, TQString/*album*/=0, TQString/*tracknumber*/=0, TQString/*genre*/=0 ) {}
	virtual char* getHeader( int&/*len*/ ) {return NULL;}
	virtual char* encode( char*/*data*/, int /*datalen*/, int&/*len*/ ) {return NULL;}
	virtual char* stop( int& /*len*/) {return NULL;}
};

#endif /* KAFFEINEAUDIOENCODER_H */
