// (C) 2005 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#ifndef CODEINEPLAYDIALOG_H
#define CODEINEPLAYDIALOG_H

#include <kurl.h>
#include <tqdialog.h>

class TDEListView;
class TQBoxLayout;
class TQListViewItem;

namespace Codeine
{
   class PlayDialog : public TQDialog
   {
   Q_OBJECT
   public:
      PlayDialog( TQWidget*, bool show_welcome_dialog = false );

      const KURL &url() const { return m_url; }

      enum DialogCode { FILE = TQDialog::Accepted + 2, VCD, CDDA, DVD, RECENT_FILE };

   private slots:
      void done( TQListViewItem* );

   private:
      void createRecentFileWidget( TQBoxLayout* );

      KURL m_url;
   };
}

#endif
