/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef REZKONVIMPORTER_H
#define REZKONVIMPORTER_H

#include <ntqstringlist.h>

#include "baseimporter.h"
#include "datablocks/recipe.h"

class RezkonvImporter : public BaseImporter
{
public:
	RezkonvImporter();
	~RezkonvImporter();

protected:
	void parseFile( const TQString &filename );

private:
	void loadIngredient( const TQString &line, Recipe & recipe, bool &is_sub );
	void loadIngredientHeader( const TQString &line, Recipe & recipe );
	void loadInstructions( TQStringList::const_iterator &raw_text, Recipe & recipe );
	void loadReferences( TQStringList::const_iterator &raw_text, Recipe & recipe );

	void readRange( const TQString &, double &amount, double &amount_offset );
	void readRecipe( const TQStringList &raw_text );

	TQStringList::const_iterator m_end_it;

	TQString current_header;
};

#endif //REZKONVIMPORTER_H
