/***************************************************************************
*   Copyright (C) 2003-2006 by                                            *
*   Jason Kivlighn (jkivlighn@gmail.com                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef HTMLEXPORTER_H
#define HTMLEXPORTER_H

#include <ntqdom.h>
#include <ntqmap.h>

#include "baseexporter.h"
#include "klomanager.h"

class RecipeDB;
class KProgress;

/**
  * Exports a given recipe list as HTML
  * @author Jason Kivlighn
  */
class HTMLExporter : public BaseExporter, protected KLOManager
{
public:
	HTMLExporter( const TQString&, const TQString& );
	virtual ~HTMLExporter();

	virtual int supportedItems() const;

	static void removeHTMLFiles( const TQString &filename, int recipe_id );
	static void removeHTMLFiles( const TQString &filename, const TQValueList<int> &recipe_ids );

	void setTemplate( const TQString &filename );
	void setStyle( const TQString &filename );

protected:
	TQString createContent( const Recipe& recipe );
	virtual TQString createContent( const RecipeList & );
	virtual TQString createHeader( const RecipeList & );
	virtual TQString createFooter();

	virtual int progressInterval() const { return 1; }

	virtual void loadBackgroundColor( const TQString &obj, const TQColor& );
	virtual void loadFont( const TQString &obj, const TQFont& );
	virtual void loadTextColor( const TQString &obj, const TQColor& );
	virtual void loadVisibility( const TQString &obj, bool );
	virtual void loadAlignment( const TQString &obj, int );
	virtual void loadBorder( const TQString &obj, const KreBorder& );
	virtual void loadColumns( const TQString & obj, int cols );

	virtual void beginObject( const TQString &obj );
	virtual void endObject();

	static TQString escape( const TQString & );

	TQString m_templateContent;

private:
	void storePhoto( const Recipe &recipe );
	void populateTemplate( const Recipe &recipe, TQString &content );
	void replaceIfVisible( TQString &content, const TQString &name, const TQString &html );
	TQString HTMLIfVisible( const TQString &name, const TQString &html );

	TQString m_layoutFilename;
	TQString m_templateFilename;
	TQString m_cachedCSS;
	TQMap<TQString,bool> m_visibilityMap;
	TQMap<TQString,int> m_columnsMap;
	bool m_error;
};

#endif //HTMLEXPORTER_H
