/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef RECIPEVIEWDIALOG_H
#define RECIPEVIEWDIALOG_H

#include <ntqvbox.h>
#include <ntqstring.h>

class RecipeDB;
class Recipe;
class TDEHTMLPart;
class TQPushButton;

/**
@author Unai Garro
*/

class RecipeViewDialog : public TQVBox
{
	Q_OBJECT

public:
	RecipeViewDialog( TQWidget *parent, RecipeDB *db, int recipeID = -1 );

	~RecipeViewDialog();

	/** @return Boolean indicating whether or not the recipe was successfully loaded */
	bool loadRecipe( int recipeID );

	/** @return Boolean indicating whether or not the recipes were successfully loaded */
	bool loadRecipes( const TQValueList<int> &ids, const TQString &layoutConfig = TQString::null );

	int recipesLoaded() const
	{
		return ids_loaded.count();
	}
	const TQValueList<int> currentRecipes() const
	{
		return ids_loaded;
	}

	void reload( const TQString &layoutConfig = TQString::null );

public slots:
	void printNoPreview( void );
	void print( void );

private:

	// Internal Variables
	TDEHTMLPart *recipeView;
	RecipeDB *database;
	bool recipe_loaded;
	TQValueList<int> ids_loaded;
	TQString tmp_filename;

	// Internal Methods
	bool showRecipes( const TQValueList<int> &ids, const TQString &layoutConfig );
	void removeOldFiles();

private slots:
	void recipeRemoved(int);

};


#endif
