/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef DIETWIZARDDIALOG_H
#define DIETWIZARDDIALOG_H

#include <stdlib.h> // For RAND_MAX

#include <ntqcheckbox.h>
#include <ntqhbox.h>
#include <ntqhgroupbox.h>
#include <ntqlabel.h>
#include <ntqptrlist.h>
#include <ntqpushbutton.h>
#include <ntqslider.h>
#include <ntqspinbox.h>
#include <ntqtabwidget.h>
#include <ntqtoolbutton.h>
#include <ntqvaluelist.h>
#include <ntqvbox.h>
#include <ntqvgroupbox.h>
#include <ntqwidgetstack.h>

#include <tdelistview.h>

#include "datablocks/constraintlist.h"
#include "datablocks/recipelist.h"
#include "datablocks/elementlist.h"
#include "datablocks/ingredientpropertylist.h"
#include "datablocks/recipe.h"
#include "datablocks/unitratiolist.h"

#include "widgets/dblistviewbase.h"

class KDoubleNumInput;

class DishInput;
class DishTitle;
class MealInput;
class RecipeDB;
class RecipeList;
class CategoryCheckListView;
class PropertyConstraintListView;

/**
@author Unai Garro
*/


class DietWizardDialog: public TQVBox
{

	Q_OBJECT

public:

	DietWizardDialog( TQWidget *parent, RecipeDB* db );
	~DietWizardDialog();

private:
	//Private variables
	RecipeDB *database;

	int dayNumber;
	int mealNumber;

	RecipeList *dietRList;

	//Widgets
	TQHBox *optionsBox;
	TQVGroupBox *mealsSliderBox;
	TQLabel *mealNumberLabel;
	TQSlider *mealNumberSelector;
	TQVGroupBox *daysSliderBox;
	TQLabel *dayNumberLabel;
	TQSlider *dayNumberSelector;
	TQTabWidget *mealTabs;
	MealInput *mealTab; // points to the current tab
	TQPushButton *okButton;

	//Methods
	bool checkCategories( Recipe &rec, int meal, int dish );
	bool checkConstraints( Recipe &rec, int meal, int dish );
	bool checkLimits( IngredientPropertyList &properties, ConstraintList &constraints );
	void loadConstraints( int meal, int dish, ConstraintList *constraints ) const;
	void loadEnabledCategories( int meal, int dish, ElementList *categories );
	void newTab( const TQString &name );
	bool categoryFiltering( int meal, int dish ) const;
	int getNecessaryFlags() const;

public:
	//Methods
	void reload( ReloadFlags flags = Load );
	RecipeList& dietList( void );

private slots:
	void changeDayNumber( int dn );
	void changeMealNumber( int mn );
	void createDiet( void );
	void clear();
	void createShoppingList( void );
	void populateIteratorList( RecipeList &rl, TQValueList <RecipeList::Iterator> *il );
signals:
	void dietReady( void );
};

class MealInput: public TQWidget
{
	Q_OBJECT

public:
	// Methods

	MealInput( TQWidget *parent, RecipeDB *database );
	~MealInput();
	void reload( ReloadFlags flag = Load );
	int dishNo( void )
	{
		return dishNumber;
	};
	void setDishNo( int dn );
	void showDish( int dn );

	// Public widgets and variables
	TQValueList <DishInput*> dishInputList; // The list of dishes

private:
	// Widgets
	// Private Variables
	int dishNumber;
	RecipeDB *database;

	// Settings section for the meal
	TQHBox *mealOptions;

	// Dish number setting
	TQHBox *dishNumberBox;
	TQLabel *dishNumberLabel;
	TQSpinBox *dishNumberInput;

	// Move <-> buttons
	TQHGroupBox *toolBar;
	TQToolButton *buttonNext;
	TQToolButton *buttonPrev;

	// Settings for the dish
	TQWidgetStack *dishStack;

public slots:
	void nextDish( void );
	void prevDish( void );

private slots:
	void changeDishNumber( int dn );

};

class DishInput: public TQWidget
{
	Q_OBJECT

public:
	DishInput( TQWidget *parent, RecipeDB *database, const TQString &title );
	~DishInput();
	// Methods
	bool isCategoryFilteringEnabled( void ) const;
	void loadConstraints( ConstraintList *constraints ) const;
	void loadEnabledCategories( ElementList* categories );
	void reload( ReloadFlags flag = Load );
	void setDishTitle( const TQString & text );
	void clear();


private:
	// Variables
	bool categoryFiltering;
	// Widgets
	TQHGroupBox *listBox;
	DishTitle *dishTitle;
	TQVBox *categoriesBox;
	TQCheckBox *categoriesEnabledBox;
	CategoryCheckListView *categoriesView;
	PropertyConstraintListView *constraintsView;
	KDoubleNumInput *constraintsEditBox1;
	KDoubleNumInput *constraintsEditBox2;
	RecipeDB *database;

private slots:
	void enableCategories( bool enable );
	void insertConstraintsEditBoxes( TQListViewItem* it );
	void hideConstraintInputs();
	void setMinValue( double minValue );
	void setMaxValue( double maxValue );
};

class DishTitle: public TQWidget
{

	Q_OBJECT

public:
	DishTitle( TQWidget *parent, const TQString &title );
	~DishTitle();
	virtual TQSize sizeHint () const;
	virtual TQSize minimumSizeHint() const;
protected:
	//Variables
	TQString titleText;
	//Methods
	virtual void paintEvent( TQPaintEvent *p );
};

#endif
