/***************************************************************************
*   Copyright (C) 2004 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef BORDERDIALOG_H
#define BORDERDIALOG_H

#include <kdialogbase.h>
#include <kcolordialog.h>

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQGroupBox;
class TQLabel;
class TDEListBox;
class TQListBoxItem;
class TQSpinBox;
class TDEHTMLPart;

class KreBorder;

class BorderDialog : public KDialogBase
{
	Q_OBJECT

public:
	BorderDialog( const KreBorder &border, TQWidget* parent = 0, const char* name = 0 );
	~BorderDialog();

	KreBorder border() const;

	TQGroupBox* borderGroupBox;
	TQLabel* styleLabel;
	TDEListBox* styleListBox;
	TQLabel* colorLabel;
	KHSSelector* hsSelector;
	KValueSelector* valuePal;
	TQLabel* widthLabel;
	TQSpinBox* widthSpinBox;
	TDEListBox* widthListBox;
	TDEHTMLPart* borderPreview;

protected:
	TQVBoxLayout* borderGroupBoxLayout;
	TQHBoxLayout* layout4;
	TQVBoxLayout* layout3;
	TQVBoxLayout* layout2;
	TQVBoxLayout* layout1;

protected slots:
	virtual void languageChange();
	void updatePreview();
	void updateSpinBox( int index );

	void slotHSChanged( int h, int s );
	void slotVChanged( int v );
	void setColor( const KColor &color );

private:
	void loadBorder( const KreBorder &border );
	void initListBoxs();

	KColor selColor;

};

#endif // BORDERDIALOG_H
