/***************************************************************************
*   Copyright (C) 2005                                                    *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef SEARCHPARAMETERS_H
#define SEARCHPARAMETERS_H

#include <ntqstring.h>
#include <ntqstringlist.h>
#include <ntqdatetime.h>

class RecipeSearchParameters
{
public:
	RecipeSearchParameters() : servings(-1)/*, averageRating(-1), averageRatingOffset(0)*/
	{}

	TQStringList titleKeywords;
	bool requireAllTitleWords;

	TQStringList instructionsKeywords;
	bool requireAllInstructionsWords;

	TQStringList ingsOr;
	TQStringList catsOr;
	TQStringList authorsOr;

	TQTime prep_time;

	/** 0 -> greater than given time
	  * 1 -> less than given time
	  * 2 -> about given time
	  */
	int prep_param;

	int servings;

	/** 0 -> greater than given time
	  * 1 -> less than given time
	  * 2 -> about given time
	  */
	int servings_param;

	TQDateTime createdDateBegin;
	TQDateTime createdDateEnd;
	TQDateTime modifiedDateBegin;
	TQDateTime modifiedDateEnd;
	TQDateTime accessedDateBegin;
	TQDateTime accessedDateEnd;

	//RatingCriteriaList criteriaList;
	//double averageRating;
	//double averageRatingOffset;
};


#endif
