/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CERTCONFIGPAGE_H
#define CERTCONFIGPAGE_H

#include <kwizard.h>

#include "certconfigpagedlg.h"

class TQStringList;

/**Abstract class for the first wizard page. Sets the according selection on save()
  *@author Timothy Pearson
  */

class SecondaryCertConfigPage : public SecondaryCertConfigPageDlg  {
	Q_OBJECT

public:
	SecondaryCertConfigPage(TQWidget *parent=0, const char *name=0);
	~SecondaryCertConfigPage();

public slots:
	void validateEntries();
	void processLockouts();

private slots:
	void setUseGeneratedKeys(int state);
	void setUseProvidedKeys(int state);

private:
	KWizard* m_parentWizard;
	KDialogBase* m_parentDialog;
};

#endif
