/*
 * kbiffcrypt.h
 * Copyright (C) 2005 Michael Hendricks <michael@palmcluster.org>
 *
 * $Id$
 *
 */
#ifndef KBIFFCRYPT_H
#define KBIFFCRYPT_H

#include <ntqstring.h>

/**
 * @brief Useful cryptographic functions for secure authentication
 *
 * Until TQCA
 * (<a href='http://delta.affinix.com/qca/'>TQt Cryptographic Architecture</a>)
 * becomes more widely available,
 * this will be the place for our custom-written, cryptography functions.
 * These are mostly needed to implement various forms of secure authentication
 * against POP3 or IMAP mail servers.
 */
namespace KBiffCrypt
{
    /**
     *  @brief Calculate HMAC-MD5 of the given text
     *
     *  Calculates the HMAC-MD5 as specified in RFC 2104.  The code
     *  is originally based on the example code provided in the RFC,
     *  but it has been modified to remove the dependency on the
     *  OpenSSL libraries.  It, instead, depends on KMD5 provided by
     *  KDE.
     *
     *  The emphasis in writing this function was readability not speed.
     *  Since the client will authenticate itself against the server
     *  every couple minutes (at the most), the speed of the function
     *  is essentially unimportant.  The maintainability of the code
     *  seemed more important.  That's not to say that the function is
     *  slow, it simply hasn't been optimized for speed.  If you want
     *  to call this function several times per second, look elsewhere.
     *
     *  @param text calculate the HMAC-MD5 of this text
     *  @param key  the key used when calculating the HMAC
     *  @return the HMAC-MD5 value as a string of lower-case, hexadecimal digits
     */
    TQString hmac_md5(const TQString& text, const TQString& key);
}

#endif // KBIFFCRYPT_H
