/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/


#ifndef _TDESVNVIEW_H_
#define _TDESVNVIEW_H_

#include "repositorylistener.h"
#include <tqwidget.h>
#include <tdeparts/part.h>

class TQPainter;
class KURL;
class tdesvnfilelist;
class KdeSvnDirList;
class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQSplitter;
class TDEActionCollection;
class KTextBrowser;
class KProgress;


/**
 * This is the main view class for tdesvn.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * @short Main view
 * @author Rajko Albrecht <ral@alwins-world.de>
 * @version 0.1
 */
class tdesvnView : public TQWidget,public svn::repository::RepositoryListener
{
    Q_OBJECT
  
public:
    /**
     * Default constructor
     */
    tdesvnView(TDEActionCollection*,TQWidget *parent,const char*name=0,bool full=false);

    /**
     * Destructor
     */
    virtual ~tdesvnView();

    /**
     * Random 'get' function
     */
    TQString currentURL();

    /**
     * Random 'set' function accessed by DCOP
     */
    virtual bool openURL(TQString url);

    /**
     * Random 'set' function
     */
    virtual bool openURL(const KURL& url);

    /* repositorylistener methods */
    virtual void sendWarning(const TQString&);
    virtual void sendError(const TQString&);
    virtual bool isCanceld();

signals:
    /**
     * Use this signal to change the content of the statusbar
     */
    void signalChangeStatusbar(const TQString&);

    /**
     * Use this signal to change the content of the caption
     */
    void signalChangeCaption(const TQString&);

    void sigShowPopup(const TQString&,TQWidget**);
    void sigSwitchUrl(const KURL&);
    void setWindowCaption(const TQString&);
    void sigUrlChanged(const TQString&);
    void sigMakeBaseDirs();

    /* repositorylistener methods */
    void tickProgress();
    void waitShow(bool);

public slots:
    virtual void closeMe();
    virtual void slotDispPopup(const TQString&,TQWidget**);
    virtual void refreshCurrentTree();
    virtual void slotSettingsChanged();
    virtual void slotCreateRepo();
    virtual void slotDumpRepo();
    virtual void slotHotcopy();
    virtual void slotLoaddump();

    /* repositorylistener methods */
    virtual void setCanceled(bool);
    virtual void fillCacheStatus(TQ_LONG,TQ_LONG);

protected slots:
    virtual void slotOnURL(const TQString& url);
    virtual void slotSetTitle(const TQString& title);
    virtual void slotAppendLog(const TQString& text);
    virtual void slotUrlChanged(const TQString&);

protected:
    tdesvnfilelist*m_flist;
    TDEActionCollection*m_Collection;

    TQSplitter *m_Splitter,*m_infoSplitter;
    TQString m_currentURL;
    KTextBrowser*m_LogWindow;
    TQVBoxLayout*m_topLayout;
    KProgress*m_CacheProgressBar;

protected:
    virtual void setupActions();
    bool m_ReposCancel;
};

#endif // _TDESVNVIEW_H_
