/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef _TDESVNPART_H_
#define _TDESVNPART_H_

#include "tdesvn-config.h"

#include <tdeparts/part.h>
#include <tdeparts/genericfactory.h>
#include <tdeparts/factory.h>
#include <tdeparts/statusbarextension.h>
#include <tdeparts/browserextension.h>

class tdesvnView;
class TQPainter;
class KURL;
class KdesvnBrowserExtension;
class TDEAboutApplication;

/**
 * This is a "Part".  It that does all the real work in a KPart
 * application.
 *
 * @short Main Part
 * @author Rajko Albrecht <rajko.albrecht@tecways.com>
 * @version 0.1
 */
class KDESVN_EXPORT tdesvnPart : public KParts::ReadOnlyPart
{
    Q_OBJECT
  
public:
    /**
     * Default constructor
     */
    tdesvnPart(TQWidget *parentWidget, const char *widgetName,
                    TQObject *parent, const char *name, const TQStringList&);

    tdesvnPart(TQWidget *parentWidget, const char *widgetName,
               TQObject *parent, const char *name,bool ownapp, const TQStringList&);

    /**
     * Destructor
     */
    virtual ~tdesvnPart();
    virtual bool closeURL();
    static TDEAboutData* createAboutData();

signals:
    void refreshTree();
    void settingsChanged();

public slots:
    virtual void slotDispPopup(const TQString&,TQWidget**target);
    virtual void slotFileProperties();
    virtual bool openURL(const KURL&);
    virtual void slotSshAdd();

protected:
    /**
     * This must be implemented by each part
     */
    virtual bool openFile();
    virtual void setupActions();
    TDEAboutApplication* m_aboutDlg;

    void init(TQWidget *parentWidget, const char *widgetName,bool full);

protected slots:
    virtual void slotLogFollowNodes(bool);
    virtual void slotDisplayIgnored(bool);
    virtual void slotDisplayUnkown(bool);
    virtual void slotUrlChanged(const TQString&);
    void reportBug();
    void showAboutApplication();
    void appHelpActivated();
    virtual void slotShowSettings();

private:
    tdesvnView *m_view;
    KdesvnBrowserExtension*m_browserExt;
protected slots:
    void slotSettingsChanged();
protected slots:
    virtual void slotHideUnchanged(bool);
    virtual void slotEnableNetwork(bool);
};

class commandline_part;
class TDECmdLineArgs;

/* we make it ourself 'cause we will enhance a little bit! */
class KDESVN_EXPORT cFactory : public KParts::Factory
{
    Q_OBJECT
  
public:
    cFactory():KParts::Factory(){}
    virtual ~cFactory();
    virtual KParts::Part* createPartObject( TQWidget *parentWidget, const char *widgetName,
                                            TQObject *parent, const char *name,
                                            const char *classname, const TQStringList &args );
    virtual KParts::Part* createAppPart( TQWidget *parentWidget, const char *widgetName,
                                            TQObject *parent, const char *name,
                                            const char *classname, const TQStringList &args );
    virtual commandline_part*createCommandIf(TQObject*parent,const char*name, TDECmdLineArgs *args);
    static TDEInstance* instance();

private:
    static TDEInstance* s_instance;
    static TDEAboutData* s_about;
    static commandline_part*s_cline;
};

typedef cFactory tdesvnPartFactory;

class TDEPARTS_EXPORT KdesvnBrowserExtension : public KParts::BrowserExtension
{
    Q_OBJECT
  
public:
    KdesvnBrowserExtension( tdesvnPart * );
    virtual ~KdesvnBrowserExtension();
    void setPropertiesActionEnabled(bool enabled);

public slots:
    void properties();
};

#endif // _TDESVNPART_H_
