/***************************************************************************
 *   Copyright (C) 2005-2006 Nicolas Hadacek <hadacek@kde.org>             *
 *   Copyright (C) 2003 Alain Gibaud <alain.gibaud@free.fr>                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "project_editor.h"

#include <tqlabel.h>
#include <tqlayout.h>
#include <tdelocale.h>

#include "project.h"
#include "tools/list/compile_config.h"
#include "device_gui.h"

ProjectEditor::ProjectEditor(Project &project, TQWidget *parent)
  : Dialog(parent, "project_options", true, i18n("Project Options"), Ok|Cancel, Ok, false),
    _project(project)
{
   TQVBoxLayout *top = new TQVBoxLayout(mainWidget(), 0, 10);
  TabWidget *tabWidget = new TabWidget(mainWidget());
  top->addWidget(tabWidget);

// global
  TQWidget *tab = new TQWidget(tabWidget);
  tabWidget->addTab(tab, i18n("General"));
  TQGridLayout *grid = new TQGridLayout(tab, 0, 0, 10, 10);
  TQLabel *label = new TQLabel(i18n("Name:"), tab);
  grid->addWidget(label, 0, 0);
  label = new TQLabel(project.name(), tab);
  grid->addWidget(label, 0, 1);
  label = new TQLabel(i18n("Description:"), tab);
  grid->addWidget(label, 1, 0);
  _description = new TQTextEdit(tab);
  _description->setText(_project.description());
  grid->addMultiCellWidget(_description, 1,1, 1,2);
  label = new TQLabel(i18n("Version:"), tab);
  grid->addWidget(label, 2, 0);
  _version = new TQLineEdit(tab);
  _version->setText(_project.version());
  grid->addWidget(_version, 2, 1);
  label = new TQLabel(i18n("Device:"), tab);
  grid->addWidget(label, 3, 0);
  _device = new DeviceChooser::Button(false, tab);
  _device->setDevice(Compile::Config::device(&_project));
  grid->addWidget(_device, 3, 1);
  grid->setRowStretch(4, 1);
  grid->setColStretch(2, 1);

// toochain
  tab = new TQWidget(tabWidget);
  tabWidget->addTab(tab, i18n("Toochain"));
  grid = new TQGridLayout(tab, 0, 0, 10, 10);
  _tools = new ToolsConfigWidget(&project, tab);
  _tools->loadConfig();
  grid->addMultiCellWidget(_tools, 0,0, 0,2);
  grid->setRowStretch(1, 1);
  grid->setColStretch(2, 1);
}

void ProjectEditor::slotOk()
{
  _project.setDescription(_description->text());
  _project.setVersion(_version->text());
  Compile::Config::setDevice(&_project, _device->device());
  _tools->saveConfig();
  accept();
}
