/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "mem24_hex_view.h"

#include <tqlayout.h>
#include <tqlabel.h>
#include <tdelocale.h>

#include "mem24_memory_editor.h"

Mem24::HexView::HexView(const HexEditor &editor, TQWidget *parent)
  : Device::HexView(editor, parent, "mem24_hex_view")
{}

void Mem24::HexView::display()
{
  Memory *pmemory = static_cast<Memory *>(_memory);
  MemoryTypeEditor *e = new MemoryTypeEditor(this, *pmemory, this);
  e->init(true);
  e->show();
  _top->addWidget(e);
  addEditor(e);
}

BitValue Mem24::HexView::checksum() const
{
  if ( _memory==0 ) return 0x0000;
  BitValue cs = 0x0000;
  for (uint i=0; i<static_cast<const Data &>(_memory->device()).nbBytes(); i++)
    cs += static_cast<const Memory *>(_memory)->byte(i);
  return cs.maskWith(0xFFFF);
}
