/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef REGISTER_VIEW_H
#define REGISTER_VIEW_H

#include <tqframe.h>

#include "devices/base/register.h"
#include "common/gui/number_gui.h"
#include "common/gui/list_view.h"

namespace Register
{
enum { PortBitRtti = 1000, RegisterRtti = 1001 };

//-----------------------------------------------------------------------------
class PortBitListViewItem : public TDEListViewItem
{
public:
  PortBitListViewItem(uint address, uint bit, TDEListViewItem *parent);
  virtual int rtti() const { return PortBitRtti; }
  void updateView();
  TQString tooltip(int column) const;

private:
  uint _index, _bit;

  virtual void paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int align);
};

//-----------------------------------------------------------------------------
class ListViewItem : public EditListViewItem
{
public:
  ListViewItem(const TypeData &data, TDEListViewItem *item);
  virtual int rtti() const { return RegisterRtti; }
  virtual void updateView();
  const TypeData &data() const { return _data; }
  TQString tooltip(int column) const;
  NumberBase base() const { return _base; }
  void setBase(NumberBase base);
  virtual TQString label() const = 0;
  virtual int compare(TQListViewItem *item, int, bool) const;

protected:
  TypeData _data;
  TQValueList<PortBitListViewItem *> _items;
  NumberBase _base;

  virtual void paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int align);
  virtual TQWidget *editWidgetFactory(int col) const;
  virtual bool alwaysAcceptEdit(int) const { return false; }
  virtual void editDone(int col, const TQWidget *editWidget);
  virtual uint nbCharsAddress() const = 0;
  virtual TQString text() const;
  virtual void activate() {}
};

//-----------------------------------------------------------------------------
class LineEdit : public NumberLineEdit
{
Q_OBJECT
  
public:
  LineEdit(TQWidget *parent, const char *name = 0);
  void setValue(NumberBase base, BitValue value, uint nbChars);
  BitValue value() const { return _value; }

signals:
  void modified();

protected:
  virtual void keyPressEvent(TQKeyEvent *e);

private slots:
  void updateText();
  void returnPressedSlot();

private:
  NumberBase _base;
  BitValue   _value;
  uint       _nbChars;
};

//-----------------------------------------------------------------------------
class View : public TQFrame, public GenericView
{
Q_OBJECT
  
public:
  View(TQWidget *parent, const char *name);

signals:
  void readSignal(uint address);
  void writeSignal(uint address, uint value);
  void setWatchedSignal(uint address, bool watched);
};

} // namespace

#endif
