/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "number_gui.h"

#include <tqfontmetrics.h>

//-----------------------------------------------------------------------------
uint maxCharWidth(const TQString &s, const TQFont &font)
{
  TQFontMetrics fm(font);
  uint w = 0;
  for (uint i=0; i<uint(s.length()); i++)
    w = TQMAX(w, uint(fm.width(s[i])));
  return w;
}

uint maxCharWidth(NumberBase base, const TQFont &font)
{
  TQString s;
  for (uint i=0; i<base.data().base; i++) s += toChar(base, i);
  return maxCharWidth(s, font);
}

uint maxLabelWidth(NumberBase base, uint nbChars, const TQFont &font)
{
  uint w = maxStringWidth(base, nbChars, font);
  TQFontMetrics fm(font);
  if ( base==NumberBase::String ) return w + 2 * fm.width("\"");
  return w + fm.width(base.data().prefix);
}

//-----------------------------------------------------------------------------
NumberLineEdit::NumberLineEdit(TQWidget *parent, const char *name)
  : KLineEdit(parent, name)
{
  connect(this, TQT_SIGNAL(textChanged(const TQString &)), TQT_SLOT(textChangedSlot()));
}

NumberLineEdit::NumberLineEdit(const TQString &text, TQWidget *parent, const char *name)
  : KLineEdit(text, parent, name)
{
  connect(this, TQT_SIGNAL(textChanged(const TQString &)), TQT_SLOT(textChangedSlot()));
}

TQValidator::State validateNumber(const TQString &input)
{
  if ( input.isEmpty() ) return TQValidator::Intermediate;
  bool ok;
  (void)fromAnyLabel(input, &ok);
  if (ok) return TQValidator::Acceptable;
  FOR_EACH(NumberBase, base)
    if ( input==base.data().prefix ) return TQValidator::Intermediate;
  if ( input[0]=='\"' ) return TQValidator::Intermediate;
  if ( input[0]=='\'' ) return TQValidator::Intermediate;
  return TQValidator::Invalid;
}

void NumberLineEdit::textChangedSlot()
{
  TQValidator::State state = validateNumber(text());
  switch (state) {
    case TQValidator::Acceptable: unsetColor(); break;
    case TQValidator::Intermediate: setColor(TQColor("#FF9900")); break;
    case TQValidator::Invalid: setColor(red); break;
  }
}
