/***************************************************************************
 *   Copyright (C) 2007 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef PROGRESS_MONITOR_H
#define PROGRESS_MONITOR_H

#include "global.h"

class ProgressMonitor : public TQObject
{
Q_OBJECT
  
public:
  ProgressMonitor(TQObject *parent = 0);
  void clear();
  void appendTask(const TQString &label, uint nbSteps);
  void insertTask(const TQString &label, uint nbSteps);
  void startNextTask();
  void addTaskProgress(uint nbSteps);
  uint nbSteps() const;
  uint nbDoneSteps() const;

public slots:
  void update();

signals:
  void showProgress(bool show);
  void setLabel(const TQString &label);
  void setTotalProgress(uint nbSteps);
  void setProgress(uint nbSteps);

private:
  class Task {
  public:
    TQString label;
    uint nbSteps, nbDoneSteps;
  };
  TQValueList<Task> _tasks;
  TQValueList<Task>::iterator _current;
};

#endif
