/***************************************************************************
                          receiversview.cpp  -  description
                             -------------------
    begin                : Tue Jan 11 2005
    copyright            : (C) 2005 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqobjectdict.h>
#include <tqobjectlist.h>
#include <tqmetaobject.h>
#include <tqstrlist.h>
#include <tqvariant.h>
#include <tqsignalslotimp.h>

#include <tdelocale.h>

#include "receiversview.h"

class UnencapsulatedTQObject : public TQObject {
public:
    TQConnectionList *public_receivers(int signal) const { return receivers(signal); }
};

ReceiversView::ReceiversView(TQWidget *parent, const char *name ) : TDEListView(parent,name)
{
  addColumn( i18n( "Object" ) );
  addColumn( i18n( "Type" ) );
  addColumn( i18n( "Member Name" ) );

  setRootIsDecorated( true );
  setAllColumnsShowFocus( true );
  setFullWidth( true );
}

ReceiversView::~ReceiversView()
{
}

void ReceiversView::buildList( TQObject *o )
{
  TQMetaObject *mo = o->metaObject();
    
  UnencapsulatedTQObject * qobject = (UnencapsulatedTQObject *) o;
  TQStrList signalNames = mo->signalNames(true);
    
  for (int sig = 0; sig < mo->numSignals(true); sig++) {
    TQConnectionList * clist = qobject->public_receivers(sig);
    if (clist != 0) {
      TDEListViewItem *conn = new TDEListViewItem( this, signalNames.at(sig) );
            
      for (    TQConnection * connection = clist->first(); 
               connection != 0; 
               connection = clist->next() ) 
      {
        new TDEListViewItem( conn,
                           connection->object()->name(), 
                           connection->memberType() == 1 ? "SLOT" : "SIGNAL",
                           connection->memberName() );
      }
    }
  }  
}

void ReceiversView::setTarget( TQObject *o )
{
  clear();
  buildList( o );
}

#include "receiversview.moc"
