/*
  Copyright (C) 1999-2001 Jens Hoefkens
  jens@hoefkens.com

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  $Id$

*/

#include <tqtimer.h>
#include <tqpopupmenu.h>

#include <kdialogbase.h>

#include <kbgengine.moc>
#include "kbgengine.h"


/*
 * Constructor initializes the TQObject
 */
KBgEngine::KBgEngine(TQWidget *parent, TQString *name, TQPopupMenu *pmenu)
    : TQObject(parent, name->local8Bit())
{
    menu = pmenu;
    cl = -1;
    ct = new TQTimer(this);
    connect(ct, TQT_SIGNAL(timeout()), this, TQT_SLOT(done()));
}

/*
 * Destructor is empty
 */
KBgEngine::~KBgEngine()
{
    // empty
}

/*
 * Set the length of the commit timeout. Negative values disable the
 * feature.
 */
void KBgEngine::setCommit(const double com)
{
    cl = int(1000*com);
}

// EOF
