#ifndef __LIBR_BFD_H
#define __LIBR_BFD_H

#include "config.h"

#include <sys/types.h>
#include <stdint.h>
#include <bfd.h>

#if (__WORDSIZE == 64)
	#if defined(__i386)
		#error "Using incorrect binutils header file for architecture."
	#endif
#endif
#if (__WORDSIZE == 32)
	#if defined(__amd64)
		#error "Using incorrect binutils header file for architecture."
	#endif
#endif

#ifndef DOXYGEN_SHOULD_SKIP_THIS

typedef struct _libr_file {
	int fd_handle;
	bfd *bfd_read;
	bfd *bfd_write;
	char *filename;
	mode_t filemode;
	uid_t fileowner;
	gid_t filegroup;
	char tempfile[LIBR_TEMPFILE_LEN];
	libr_access_t access;
} libr_file;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

/* for a clean internal API */
typedef asection libr_section;
typedef void libr_data;

#endif /* __LIBR_BFD_H */
