/***************************************************************************
                          Implementation of TDENewStuff
                             -------------------
    begin                : Thu Jun 02 13:12:30 PDT 2002
    copyright            : (C) 2005 by Peter Hedlund
    email                : peter.hedlund@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWTQNEWSTUFF_H
#define KWTQNEWSTUFF_H

#include <tdenewstuff/knewstuff.h>

class KWordQuizApp;

/**
@author Peter Hedlund
*/
class KWQNewStuff : public TQObject, public TDENewStuff
{
Q_OBJECT
  
public:
  KWQNewStuff(TQWidget *parent = 0, const char *name = 0);

  /**
    Installs a downloaded file according to the application's configuration.

    @param fileName filename of the donwloaded file
    @return @c true in case of installation success, @c false otherwise
  */
  bool install(const TQString &fileName);

  /**
    Creates a file suitable for upload.
    Note that this method always fails, since using TDENewStuffGeneric
    means that the provided file must already be in a usable format.

    @param fileName the name of the file to upload after its creation
    @return @c true in case of creation success, @c false otherwise
  */
  bool createUploadFile(const TQString &fileName);

  /**
    Queries the preferred destination file for a download.

    @param entry a Hotstuff data entry
    @return destination filename, or 0 to return directory only
  */
  TQString downloadDestination(KNS::Entry *entry);

private:
  TQString destinationPath(KNS::Entry *entry);

  KWordQuizApp * m_app;
};

#endif
