/***************************************************************************

                   language properties dialog page

    -----------------------------------------------------------------------

    begin          : Wed Oct 13 18:37:13 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <langset.h>

#include "LangPropPage.h"

#include <tdelocale.h>

#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqlabel.h>

LangPropPage::LangPropPage
(
  kvoctrainDoc      *_doc,
  TQString            curr_lang,
  const Conjugation &conjug,
  const Article     &art,
  TQWidget           *parent,
  const char        *name
)
  :
  LangPropPageForm( parent, name ),
  doc(_doc),
  conjugations(conjug),
  articles(art)
{
  l_langcode->setText(curr_lang);

  connect( indef_female, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(indefFemaleChanged(const TQString&)) );
  connect( def_female, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(defFemaleChanged(const TQString&)) );
  connect( def_male, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(defMaleChanged(const TQString&)) );
  connect( indef_male, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(indefMaleChanged(const TQString&)) );
  connect( def_natural, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(defNaturalChanged(const TQString&)) );
  connect( indef_natural, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(indefNaturalChanged(const TQString&)) );
  connect( first_singular, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(firstSingularChanged(const TQString&)) );
  connect( first_plural, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(firstPluralChanged(const TQString&)) );
  connect( second_singular, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(secondSingularChanged(const TQString&)) );
  connect( second_plural, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(secondPluralChanged(const TQString&)) );
  connect( thirdF_singular, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(thirdFSingularChanged(const TQString&)) );
  connect( thirdF_plural, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(thirdFPluralChanged(const TQString&)) );
  connect( thirdM_singular, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(thirdMSingularChanged(const TQString&)) );
  connect( thirdM_plural, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(thirdMPluralChanged(const TQString&)) );
  connect( thirdN_singular, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(thirdNSingularChanged(const TQString&)) );
  connect( thirdN_plural, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(thirdNPluralChanged(const TQString&)) );

  connect( thirdS_common, TQT_SIGNAL(toggled(bool)), TQT_SLOT(slotThirdSCommonToggled(bool)) );
  connect( thirdP_common, TQT_SIGNAL(toggled(bool)), TQT_SLOT(slotThirdPCommonToggled(bool)) );

  conjugations = conjug;

  first_plural->setText (conjugations.pers1Plural (CONJ_PREFIX));
  first_singular->setText (conjugations.pers1Singular (CONJ_PREFIX));
  second_singular->setText (conjugations.pers2Singular (CONJ_PREFIX));
  second_plural->setText (conjugations.pers2Plural (CONJ_PREFIX));
  thirdF_plural->setText (conjugations.pers3FemalePlural (CONJ_PREFIX));
  thirdF_singular->setText (conjugations.pers3FemaleSingular (CONJ_PREFIX));
  thirdN_plural->setText (conjugations.pers3NaturalPlural (CONJ_PREFIX));
  thirdN_singular->setText (conjugations.pers3NaturalSingular (CONJ_PREFIX));
  thirdM_plural->setText (conjugations.pers3MalePlural (CONJ_PREFIX));
  thirdM_singular->setText (conjugations.pers3MaleSingular (CONJ_PREFIX));

  bool common = conjugations.pers3SingularCommon(CONJ_PREFIX);
  thirdS_common->setChecked(common);
  thirdM_singular->setEnabled(!common);
  thirdN_singular->setEnabled(!common);

  common = conjugations.pers3PluralCommon(CONJ_PREFIX);
  thirdP_common->setChecked(common);
  thirdN_plural->setEnabled(!common);
  thirdM_plural->setEnabled(!common);

  TQString def, indef;
  articles.female(def, indef);
  def_female->setText (def);
  indef_female->setText (indef);

  articles.male(def, indef);
  def_male->setText (def);
  indef_male->setText (indef);

  articles.natural(def, indef);
  def_natural->setText (def);
  indef_natural->setText (indef);

}


Conjugation LangPropPage::getConjugation()
{
  conjugations.cleanUp();
  return conjugations;
}


void LangPropPage::firstPluralChanged(const TQString& s)
{
  conjugations.setPers1Plural (CONJ_PREFIX, s);
}


void LangPropPage::firstSingularChanged(const TQString& s)
{
  conjugations.setPers1Singular (CONJ_PREFIX, s);
}


void LangPropPage::secondSingularChanged(const TQString& s)
{
  conjugations.setPers2Singular (CONJ_PREFIX, s);
}


void LangPropPage::secondPluralChanged(const TQString& s)
{
  conjugations.setPers2Plural (CONJ_PREFIX, s);
}


void LangPropPage::thirdFPluralChanged(const TQString& s)
{
  conjugations.setPers3FemalePlural (CONJ_PREFIX, s);
}


void LangPropPage::thirdFSingularChanged(const TQString& s)
{
  conjugations.setPers3FemaleSingular (CONJ_PREFIX, s);
}


void LangPropPage::thirdMSingularChanged(const TQString& s)
{
  conjugations.setPers3MaleSingular (CONJ_PREFIX, s);
}


void LangPropPage::thirdNSingularChanged(const TQString& s)
{
  conjugations.setPers3NaturalSingular(CONJ_PREFIX, s);
}


void LangPropPage::thirdNPluralChanged(const TQString& s)
{
  conjugations.setPers3NaturalPlural (CONJ_PREFIX, s);
}


void LangPropPage::thirdMPluralChanged(const TQString& s)
{
  conjugations.setPers3MalePlural (CONJ_PREFIX, s);
}


void LangPropPage::slotThirdSCommonToggled(bool common)
{
  conjugations.setPers3SingularCommon(CONJ_PREFIX, common);
  thirdN_singular->setEnabled(!common);
  thirdM_singular->setEnabled(!common);
}


void LangPropPage::slotThirdPCommonToggled(bool common)
{
  conjugations.setPers3PluralCommon(CONJ_PREFIX, common);
  thirdN_plural->setEnabled(!common);
  thirdM_plural->setEnabled(!common);
}


void LangPropPage::defFemaleChanged(const TQString& s)
{
  TQString def, indef;
  articles.female(def, indef);
  articles.setFemale(s, indef);
}


void LangPropPage::indefFemaleChanged(const TQString& s)
{
  TQString def, indef;
  articles.female(def, indef);
  articles.setFemale(def, s);
}


void LangPropPage::defMaleChanged(const TQString& s)
{
  TQString def, indef;
  articles.male(def, indef);
  articles.setMale(s, indef);
}


void LangPropPage::indefMaleChanged(const TQString& s)
{
  TQString def, indef;
  articles.male(def, indef);
  articles.setMale(def, s);
}


void LangPropPage::defNaturalChanged(const TQString& s)
{
  TQString def, indef;
  articles.natural(def, indef);
  articles.setNatural(s, indef);
}


void LangPropPage::indefNaturalChanged(const TQString& s)
{
  TQString def, indef;
  articles.natural(def, indef);
  articles.setNatural(def, s);
}

#include "LangPropPage.moc"
