/***************************************************************************
 *   Copyright (C) 2004-2005 by Albert Astals Cid                          *
 *   tsdgeos@terra.es                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KGEOGRAPHY_H
#define KGEOGRAPHY_H

#include <tdemainwindow.h>

class TDEAction;
class KPushButton;
class TDEToggleAction;

class TQHBox;
class TQLabel;
class TQVBox;

class KGmap;
class askWidget;

class kgeography : public TDEMainWindow
{
Q_OBJECT
  
	public:
		kgeography();
		~kgeography();
	
	protected:
		void showEvent(TQShowEvent *e);

	private slots:
		void openMap();

		void consult();
		void askCapitalDivisions();
		void askDivisionCapitals();
		void askMap();
		void askFlagDivisions();
		void askDivisionFlags();
		void disclaimer();
		void resizeMainWindow();
		void showResultsDialog();

	private:
		TQSize getPreferredSize();
		
		void putAskWidget();
		void removeOldAskWidget();
		void setMap(KGmap *m);

		TQHBox *p_bigWidget;
		TQVBox *p_underLeftWidget;

		KPushButton *p_consult;
		KPushButton *p_askCapitalDivisions;
		KPushButton *p_askDivisionCapitals;
		KPushButton *p_askMap;
		KPushButton *p_askFlagDivisions;
		KPushButton *p_askDivisionFlags;
		TDEToggleAction *p_zoom, *p_move;
		TDEAction *p_zoomOriginal;
		TQLabel *p_currentMap;

		KGmap *p_map;
		askWidget *p_askWidget;
		bool p_firstShow, p_mustShowResultsDialog;
};

#endif
