/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/



#ifndef DEBLOCATE_H
#define DEBLOCATE_H

#include "../config.h"

// Standard Headers
#include <stdio.h>

// TQt Headers
#include <tqdir.h>
#include <tqwidget.h>
#include <tqframe.h>
#include <tqlabel.h>
#include <tqfiledialog.h>
#include <tqgroupbox.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqlineedit.h>

// KDE headers
#include <kbuttonbox.h>
#include <kdialogbase.h>

class pkgInterface;
class updateLoc;
class cacheObj;
class LcacheObj;
class KComboBox;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class dpanel : public TQWidget
{
  Q_OBJECT
  

public:
  dpanel(TQWidget *parent, const char * name  = 0);
  dpanel(dpanel *basep,  const TQString &Pfilter,  bool bsubdirs,
	 TQWidget *parent, const char * name = 0);
  ~dpanel();


  TQString getText() const;
  void setText(const TQString &s);
  bool getUse() const;
  void setUse(int n);
  bool getSubdirs() const;
  void setSubdirs(int n);

private:

  TQCheckBox *psubdirs;
  TQCheckBox *puse;
  TQHBoxLayout* pack;
  TQLineEdit *pent;
  TQPushButton *pbut;

  dpanel *base;
  TQString filter;

 public slots:
  void fileOpen();
  void dirOpen();

};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class apanel : public TQWidget
{
  Q_OBJECT
  

public:
  apanel( TQWidget *parent, const char * name  = 0 );
  ~apanel();


  TQString getText() const;
  void setText(const TQString &s);
  bool getUse();
  void setUse(int n);
  void clear();

private:

  TQCheckBox *puse;
  TQHBoxLayout* pack;
  TQLineEdit *pent;



 public slots:

};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class updateLoc : public TQWidget
{
  Q_OBJECT
  

public:

  updateLoc (TQWidget *p, int panelNumber, pkgInterface *inter, const TQString &iname);
  ~updateLoc();

  virtual void readSettings() = 0;
  virtual void writeSettings() = 0;

  virtual void applyS(LcacheObj *slist) = 0;

  void doBase(const TQString &bmsg);

  TQString interName;
  int panNumber;

  bool haveBase;

  pkgInterface *interface;

  TQVBoxLayout *vf;
  dpanel *base;

  TQGroupBox *fbase;
  TQVBoxLayout* vbase;
};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class aUpdateLoc : public updateLoc
{
  Q_OBJECT
  

public:

  aUpdateLoc (TQWidget *p, int panelNumber, pkgInterface *inter, const TQString &iname,
			 int numberLines, const TQString &label);
  ~aUpdateLoc();


  void readSettings();
  void writeSettings();

  void applyS(LcacheObj *slist);

private:

   TQString packL, packU, packS,  availB;

  int wdth;

  TQPushButton  *butloc;

  TQHBoxLayout* hloc;

  int numLines;
  enum { PNUM = 100 };
  apanel *ap[PNUM];

  TQVBoxLayout* vl;
  TQVBoxLayout* vtop;
  TQGroupBox *frame1;
  KButtonBox* hb;

};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class pdUpdateLoc : public updateLoc
{
  Q_OBJECT
  

public:

  pdUpdateLoc (TQWidget *p, int panelNumber, pkgInterface *inter,
	       const TQString &iname, int numberLines, const TQString &filter,
	       const TQString &lmsg, TQString bmsg = 0,
	       bool subdirs = FALSE);
  ~pdUpdateLoc();


  void readSettings();
  void writeSettings();

  void applyS(LcacheObj *slist);

private:

   TQString packL, packU, packS,  availB;

  int wdth;

  TQPushButton  *butloc;

  TQHBoxLayout* hloc;

  int numLines;
  enum { PNUM = 40 };
  dpanel *dp[PNUM];

  TQVBoxLayout* vl;
  TQVBoxLayout* vtop;
  TQGroupBox *frame1;
  KButtonBox* hb;

};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class cUpdateLoc : public updateLoc
{
  Q_OBJECT
  

public:

  cUpdateLoc (TQWidget *p, int panelNumber, pkgInterface *inter,
	      const TQString &iname, int numberLines, const TQString &baseMsg,
		       const TQString &boxLabels, const TQString &boxValues);
  ~cUpdateLoc();


  void readSettings();
  void writeSettings();

  void applyS(LcacheObj *slist);

private:

  TQString  packC,  availB;

  TQPushButton  *butloc;

  TQHBoxLayout* hloc;

  int numLines;
  enum { PNUM = 40 };
  KComboBox *combo[PNUM];

  TQVBoxLayout* vl;
  TQVBoxLayout* vtop;
  TQGroupBox *frame1;
  KButtonBox* hb;



};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

class Locations : public KDialogBase
{
  Q_OBJECT
  

public:
  Locations( const TQString &msg);
  ~Locations();

  void dLocations(int numberDirs,  int numberLines,
		  pkgInterface *inter, const TQString &iname,
		  const TQString &label, const TQString &filter, const TQString &dirMsg,
		  bool subdirs=TRUE );

  void pLocations(int numberDirs,  int numberLines,
		  pkgInterface *inter, const TQString &iname,
		  const TQString &label, const TQString &filter,
		  const TQString &packMsg, TQString baseMsg = 0,
		  bool subdirs=FALSE);

  void cLocations(int numberDirs, int numberLines,
		  pkgInterface *inter, const TQString &iname, const TQString &label,
		  const TQString &boxLabels, const TQString &baseMsg, const TQString &boxValues);

  void aLocations(int numberDirs,   int numberLines,
		 pkgInterface *inter, const TQString &iname, const TQString &label);



  // bmsg indicates the panel has a base entry
  void restore();

  int numPanels;
  enum { PANNUM = 10 };
  updateLoc *pn[PANNUM];

public slots:
  void apply_slot();
  void write_slot();

signals:
  void returnVal(LcacheObj *);

};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#endif
