/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#include "../config.h"

#include <tqlineedit.h>
#include <tqpainter.h> 

#include <tdelocale.h>
#include <kdebug.h>
#include <kurldrag.h>
#include <kiconloader.h>

#include "kpackage.h"
#include "managementWidget.h"
#include "findf.h"
#include "options.h"
#include "pkgInterface.h"

extern pkgInterface *kpinterface[];
extern Opts *opts;

FindF::FindF(TQWidget *parent)
    : KDialogBase(parent, "find_file", false,
		i18n("Find File"),
		User1 | Close, User1, true,
		KGuiItem(i18n("&Find"),"filefind"))
{
    tick = UserIcon("ptick");

    TQFrame *page = makeMainWidget();

    setFocusPolicy(TQ_StrongFocus);

    TQVBoxLayout* vtop = new TQVBoxLayout( page, 10, 10, "vtop");
    TQFrame *frame1 = new TQGroupBox(i18n("Find Package"), page, "frame1");
    vtop->addWidget(frame1,1);
 
    TQGridLayout* gtop = new TQGridLayout( frame1, 1, 1, 20 );
    //    gtop->setMargin( KDialog::marginHint() );
    gtop->setSpacing( KDialog::spacingHint() );

    value = new TQLineEdit( frame1, "value" );
    connect(value,TQT_SIGNAL(textChanged ( const TQString & )),this,TQT_SLOT(textChanged ( const TQString & )));
    value->setFocus();

    TQLabel *valueLabel = new TQLabel(value, i18n("Find:"), frame1);
    valueLabel->setAlignment( AlignRight );

    tab = new TDEListView(frame1, "tab");
    connect(tab, TQT_SIGNAL(selectionChanged ( TQListViewItem * )),
	    this, TQT_SLOT(search( TQListViewItem * )));
    tab->addColumn(i18n("Installed"),18);
    tab->addColumn(i18n("Type"),110);
    tab->addColumn("",0);   // Hidden column for package type
    tab->addColumn(i18n("Package"),180);
    tab->addColumn(i18n("File Name"),330);
    tab->setAllColumnsShowFocus(TRUE);
    tab->setSorting(1);

    if (kpackage->management->dirInstPackages->find("apt-file/deb")) {
      searchAll = new TQCheckBox(i18n("Also search uninstalled packages"), frame1, "searchAll");
    } else {
      searchAll = new TQCheckBox(i18n("Also search uninstalled packages (apt-file needs to be installed)"), frame1, "searchAll");
    }
    searchAll->setChecked(FALSE);

    gtop->addWidget(valueLabel, 0, 0);
    gtop->addWidget(value, 0, 1);
    gtop->addMultiCellWidget(tab, 1, 1, 0, 1);

    gtop->addWidget(searchAll, 2, 0);

    connect(this, TQT_SIGNAL(user1Clicked()), this, TQT_SLOT(ok_slot()));
    connect(this, TQT_SIGNAL(closeClicked()), this, TQT_SLOT(done_slot()));
    enableButton(User1 , false);
    show();

    setAcceptDrops(true);
}

FindF::~FindF()
{
}

void FindF::checkSearchAll() 
{
    // button not enabled if no package interface has search uninstalled
    // packages for files ability
    bool hasAll = FALSE;
    for (int i = 0; i < kpinterfaceN; i++) {
      if (kpinterface[i] && opts->handlePackage[i]) {
	if (kpinterface[i]->hasSearchAll) 
	  hasAll = TRUE;
      }
    }
    
    searchAll->setEnabled(hasAll);
}

void FindF::textChanged ( const TQString & text)
{
    enableButton(User1 , !text.isEmpty());
}

void FindF::ok_slot()
{
  doFind(value->text());
}

void FindF::doFind(const TQString &str)
{
  TQString t;
  int i, cnt = 0;

  bool all = searchAll->isChecked();

  TQApplication::setOverrideCursor( waitCursor );

  tab->clear();

  for (i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i] && opts->handlePackage[i]) {
      TQStringList filelist = kpinterface[i]->FindFile(str, all);

      if (filelist.count() > 0) {
	cnt++;

	for ( TQStringList::Iterator it = filelist.begin(); it != filelist.end(); ++it ) {
	  if ((*it).find("diversion by") >= 0) {
	    new TQListViewItem(tab, "", *it);
	  }

	  int t1 = (*it).find('\t');
	  TQString s1 = (*it).left(t1);
	  TQString s2 = (*it).right((*it).length()-t1);
	  s2 = s2.stripWhiteSpace();

	  TQListViewItem *ql = new TQListViewItem(tab, "", kpinterface[i]->name, kpinterface[i]->head, s1, s2);

	  TQString tx = s1 + kpinterface[i]->typeID;
	  if (kpackage->management->dirInstPackages->find(tx)) {
	    ql->setPixmap(0,tick);
	  }
	}
      }
    }
  }

  if (!cnt) {
    new TQListViewItem(tab, "", i18n("--Nothing found--"));
  }

  TQApplication::restoreOverrideCursor();
}

void FindF::done_slot()
{
  hide();
}

void FindF::resizeEvent(TQResizeEvent *){
}

void FindF::search(TQListViewItem *item)
{
  int p;

  TQString s = item->text(3);
  s = s.stripWhiteSpace();
  kdDebug() << "searchF=" << s << "\n";

  p = s.find(',');
  if (p > 0) {
    s.truncate(p);
  }

  KpTreeListItem *k =  kpackage->management->treeList->search(s ,item->text(2));
  if (k)
    kpackage->management->treeList->changePack(k);
}

void FindF::dragEnterEvent(TQDragEnterEvent* e)
{
  e->accept(KURLDrag::canDecode(e));
}

void FindF::dropEvent(TQDropEvent *de) // something has been dropped
{
  KURL::List list;
  if (!KURLDrag::decode(de, list) || list.isEmpty())
     return;

  const KURL &url = list.first();

  if (url.isLocalFile()) {
    TQString file = url.path(-1);
    value->setText(file);
    doFind(file);
  } else {
    KpMsgE(i18n("Incorrect URL type"),FALSE);
  }
}

#include "findf.moc"
