#ifndef IOCONTROL_H
#define IOCONTROL_H

#include <tqobject.h>

class TDEProcess;
class KSircProcess;
class TQListBox;
class TQListBoxItem;

class KSircIOController : public TQObject
{

  Q_OBJECT
  
  friend class KSircProcess;
public:
  KSircIOController(TDEProcess *, KSircProcess *);
  virtual ~KSircIOController();

  void showDebugTraffic(bool show);
  bool isDebugTraffic();

public slots:
  virtual void stdout_read(TDEProcess *proc, char *_buffer, int buflen);
  virtual void stderr_read(TDEProcess *proc, char *_buffer, int buflen);

  virtual void stdin_write(TQCString);

  virtual void sircDied(TDEProcess *);

  virtual void appendDebug(TQString);


protected slots:
  virtual void procCTS(TDEProcess *);

private slots:
  void showContextMenuOnDebugWindow( TQListBoxItem *, const TQPoint &pos );

private:
  TQCString holder;
  bool proc_CTS;
  TDEProcess *proc;
  KSircProcess *ksircproc;
  char *send_buf;

  TQCString buffer;

  static int counter;

  TQListBox *m_debugLB;
};

#endif
