/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#include <tqlabel.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqstringlist.h>
#include <tqlistbox.h>

#include <tdeapplication.h>
#include <kstandarddirs.h>
#include <tdelocale.h>
#include <kurlrequester.h>
#include <tdefiledialog.h>
#include <tdemessagebox.h>
#include <kdebug.h>
#include <kcombobox.h>
#include <klineedit.h>

#include "alistbox.h"
#include "dccNew.h"
#include "objFinder.h"

dccNew::dccNew( TQWidget *parent, const char *name, int type, TQString nick )
    : dccNewBase( parent, name)
{

    TQColorGroup cg_mainw = kapp->palette().active();
    cg_mainw.setColor(TQColorGroup::Base, ksopts->backgroundColor);
    cg_mainw.setColor(TQColorGroup::Text, ksopts->textColor);
    cg_mainw.setColor(TQColorGroup::Link, ksopts->linkColor);
    cg_mainw.setColor(TQColorGroup::Highlight, ksopts->selBackgroundColor);
    cg_mainw.setColor(TQColorGroup::HighlightedText, ksopts->selForegroundColor);
    nickList->setPalette(TQPalette(cg_mainw,cg_mainw, cg_mainw));

    TQStringList allalist = objFinder::allObjects().grep(I18N_NOOP("aListBox::"));

    for ( TQStringList::Iterator it = allalist.begin();
	  it != allalist.end();
	  ++it ) {
	TQString name = (*it).section("::", 1);
	kdDebug(5008) << "Looking at: " << *it << "/" << name << endl;

	aListBox *a = static_cast<aListBox *>(TQT_TQWIDGET(objFinder::find(name.latin1(), "aListBox")));
	if(a){
	    TQListBoxItem *i;
	    for(i = a->firstItem(); i != 0x0; i = i->next()){
		nickListItem *it = new nickListItem(*a->item(a->index(i)));
		nickList->inSort(it);
	    }
	}
	else {
	    kdDebug(5008) << "Didn't find: " << name << endl;
	}
    }

    TDECompletion *comp = cbNicks->completionObject();

    TQListBoxItem *i;
    for(i = nickList->firstItem(); i != 0x0; i = i->next()){
        comp->addItem(i->text());
        cbNicks->insertItem(i->text());
    }
    cbNicks->setCurrentText(nick);

    TDEConfig *kConfig = kapp->config();
    kConfig->setGroup("dccNew");

    bool chatChecked = kConfig->readBoolEntry("chatChecked", false);

    /*
     * allow type to override
     * the config setting
     */
    if(type == Chat){
        chatChecked = true;
    }
    else if(type == Send){
        chatChecked = false;
    }

    if(chatChecked) {
	rbChat->setChecked(true);
	chatClicked();
    }
    else {
	rbFileSend->setChecked(true);
	fileSendClicked();
    }

    connect(nickList, TQT_SIGNAL(highlighted(const TQString &)),
	    cbNicks, TQT_SLOT(setEditText(const TQString &)));

    connect(pbCancel, TQT_SIGNAL(clicked()),
	    this, TQT_SLOT(reject()));

    connect(pbSend, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(accept()));


}

dccNew::~dccNew()
{
}


void dccNew::chatClicked()
{
    gbFile->setEnabled(false);
}

void dccNew::fileSendClicked()
{
    gbFile->setEnabled(true);
}

void dccNew::sendClicked()
{
    TDEConfig *kConfig = kapp->config();
    kConfig->setGroup("dccNew");
    kConfig->writeEntry("chatChecked",rbChat->isChecked());
    int type = Chat;
    if(rbFileSend->isChecked())
        type = Send;
    emit accepted(type, cbNicks->currentText(), leFile->text());
}

void dccNew::fileClicked()
{
    TQString file =
	KFileDialog::getOpenFileName();

    leFile->setText(file);
}

TQString dccNew::getFile() {
    return leFile->text() ;
}

TQString dccNew::getNick() {
    return cbNicks->currentText();
}

int dccNew::getType() {
    int type = Chat; if(rbFileSend->isChecked()) type = Send;
    return type;
}

void dccNew::reject()
{
    emit accepted(-1, TQString(), TQString());
}


#include "dccNew.moc"
