/*
 *            kPPP: A front end for pppd for the KDE project
 *
 * $Id$
 *
 * Copyright (C) 1997 Bernd Johannes Wuebben
 * wuebben@math.cornell.edu
 *
 * based on EzPPP:
 * Copyright (C) 1997  Jay Painter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with dummyWidget program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <tqlayout.h>
#include <tqslider.h>
#include <kbuttonbox.h>
#include <stdlib.h>
#include <tdeapplication.h> // for getMiniIcon()
#include <tdelocale.h>
#include "modemcmds.h"
#include "pppdata.h"
#include <twin.h>

#include <tqgroupbox.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqlabel.h>


#define ADJUSTEDIT(e) e->setText("XXXXXXXXqy"); e->setMinimumSize(e->sizeHint()); e->setFixedHeight(e->sizeHint().height()); e->setText(""); e->setMaxLength(MODEMSTR_SIZE);

// a little trick to make the label look like a disabled lineedit
#define FORMATSLIDERLABEL(l) l->setFixedWidth(l->sizeHint().width()); l->setFixedHeight(TQLineEdit(dummyWidget).sizeHint().height()); l->setAlignment(AlignCenter); l->setFrameStyle(TQFrame::WinPanel|TQFrame::Sunken); l->setLineWidth(2);

ModemCommands::ModemCommands(TQWidget *parent, const char *name)
  : KDialogBase(parent, name, true, i18n("Edit Modem Commands"), Ok|Cancel)
{
  KWin::setIcons(winId(), kapp->icon(), kapp->miniIcon());
  TQWidget *dummyWidget = new TQWidget(this);
  setMainWidget(dummyWidget);

  const int GRIDROWS = 22;
  int row = 0;

  // toplevel layout
  TQVBoxLayout *tl = new TQVBoxLayout(dummyWidget, 10, 4);

  // add grid + frame
  TQGridLayout *l1 = new TQGridLayout(GRIDROWS, 4);
  tl->addLayout(l1);
  box = new TQGroupBox(dummyWidget, "box");
  l1->addMultiCellWidget(box, row++, GRIDROWS, 0, 3);

  // put slider and label into a separate H-Box
  TQHBoxLayout *l2 = new TQHBoxLayout;
  l1->addLayout(l2, row, 2);
  lpreinitslider = new TQLabel("MMMM", dummyWidget);
  FORMATSLIDERLABEL(lpreinitslider);

  preinitslider = new TQSlider(0, 300, 1, 0,
                                       Qt::Horizontal, dummyWidget);
  preinitslider->setFixedHeight(preinitslider->sizeHint().height());
  connect(preinitslider, TQT_SIGNAL(valueChanged(int)),
	  lpreinitslider, TQT_SLOT(setNum(int)));
  l2->addWidget(lpreinitslider, 0);
  l2->addWidget(preinitslider, 1);

  lpreinit = new TQLabel(i18n("Pre-init delay (sec/100):"), dummyWidget);
  l1->addWidget(lpreinit, row++, 1);

  for(int i = 0; i < PPPData::NumInitStrings; i++) {
      initstr[i] = new TQLineEdit(dummyWidget);
      TQLabel *initLabel = new TQLabel(i18n("Initialization string %1:").arg(i + 1),
				    dummyWidget);
      ADJUSTEDIT(initstr[i]);
      l1->addWidget(initLabel, row, 1);
      l1->addWidget(initstr[i], row++, 2);
  }

  TQHBoxLayout *l3 = new TQHBoxLayout;
  l1->addLayout(l3, row, 2);
  linitslider = new TQLabel("MMMM", dummyWidget);
  FORMATSLIDERLABEL(linitslider);
  initslider = new TQSlider(1, 300, 1, 0,
				Qt::Horizontal, dummyWidget);
  initslider->setFixedHeight(initslider->sizeHint().height());
  connect(initslider, TQT_SIGNAL(valueChanged(int)),
	  linitslider, TQT_SLOT(setNum(int)));
  l3->addWidget(linitslider, 0);
  l3->addWidget(initslider, 1);

  label3 = new TQLabel(i18n("Post-init delay (sec/100):"), dummyWidget);
  l1->addWidget(label3, row++, 1);

  /* Set ATS11 (Dial tone duration) between 0-255 (Default ~ 70) */
  TQHBoxLayout *l4 = new TQHBoxLayout;
  l1->addLayout(l4, row, 2);
  ldurationslider = new TQLabel("MMMM", dummyWidget);
  FORMATSLIDERLABEL(ldurationslider);
  durationslider = new TQSlider(1, 255, 1, 0,
				Qt::Horizontal, dummyWidget);
  durationslider->setFixedHeight(durationslider->sizeHint().height());
  connect(durationslider, TQT_SIGNAL(valueChanged(int)),
	  ldurationslider, TQT_SLOT(setNum(int)));
  l4->addWidget(ldurationslider, 0);
  l4->addWidget(durationslider, 1);

  lduration = new TQLabel(i18n("Dialing speed (sec/100):"), dummyWidget);
  l1->addWidget(lduration, row++, 1);


  initresp = new TQLineEdit(dummyWidget);
  label2 = new TQLabel(i18n("Init &response:"), dummyWidget);
  label2->setBuddy(initresp);
  ADJUSTEDIT(initresp);
  l1->addWidget(label2, row, 1);
  l1->addWidget(initresp, row++, 2);

  nodetectdialtone = new TQLineEdit(dummyWidget);
  lnodetectdialtone = new TQLabel(i18n("No di&al tone detection:"), dummyWidget);
  lnodetectdialtone->setBuddy(nodetectdialtone);
  ADJUSTEDIT(nodetectdialtone);
  l1->addWidget(lnodetectdialtone, row, 1);
  l1->addWidget(nodetectdialtone, row++, 2);

  dialstr = new TQLineEdit(dummyWidget);
  label4 = new TQLabel(i18n("Dial &string:"),dummyWidget);
  label4->setBuddy(dialstr);
  ADJUSTEDIT(dialstr);
  l1->addWidget(label4, row, 1);
  l1->addWidget(dialstr, row++, 2);

  connectresp = new TQLineEdit(dummyWidget);
  label5 = new TQLabel(i18n("Co&nnect response:"), dummyWidget);
  label5->setBuddy(connectresp);
  ADJUSTEDIT(connectresp);
  l1->addWidget(label5, row, 1);
  l1->addWidget(connectresp, row++, 2);

  busyresp = new TQLineEdit(dummyWidget);
  label6 = new TQLabel(i18n("Busy response:"), dummyWidget);
  ADJUSTEDIT(busyresp);
  l1->addWidget(label6, row, 1);
  l1->addWidget(busyresp, row++, 2);

  nocarrierresp = new TQLineEdit(dummyWidget);
  label7 = new TQLabel(i18n("No carr&ier response:"), dummyWidget);
  label7->setBuddy(nocarrierresp);
  ADJUSTEDIT(nocarrierresp);
  l1->addWidget(label7, row, 1);
  l1->addWidget(nocarrierresp, row++, 2);

  nodialtoneresp = new TQLineEdit(dummyWidget);
  label8 = new TQLabel(i18n("No dial tone response:"), dummyWidget);
  ADJUSTEDIT(nodialtoneresp);
  l1->addWidget(label8, row, 1);
  l1->addWidget(nodialtoneresp, row++, 2);

  hangupstr = new TQLineEdit(dummyWidget);
  label9 = new TQLabel(i18n("&Hangup string:"), dummyWidget);
  label9->setBuddy(hangupstr);
  ADJUSTEDIT(hangupstr);
  l1->addWidget(label9, row, 1);
  l1->addWidget(hangupstr, row++, 2);

  hangupresp = new TQLineEdit(dummyWidget);
  label10 = new TQLabel(i18n("Hangup response:"), dummyWidget);
  ADJUSTEDIT(hangupresp);
  l1->addWidget(label10, row, 1);
  l1->addWidget(hangupresp, row++, 2);

  answerstr = new TQLineEdit(dummyWidget);
  label11 = new TQLabel(i18n("Answ&er string:"), dummyWidget);
  label11->setBuddy(answerstr);
  ADJUSTEDIT(answerstr);
  l1->addWidget(label11, row, 1);
  l1->addWidget(answerstr, row++, 2);

  ringresp = new TQLineEdit(dummyWidget);
  label12 = new TQLabel(i18n("Ring response:"), dummyWidget);
  ADJUSTEDIT(ringresp);
  l1->addWidget(label12, row, 1);
  l1->addWidget(ringresp, row++, 2);

  answerresp = new TQLineEdit(dummyWidget);
  label13 = new TQLabel(i18n("Ans&wer response:"), dummyWidget);
  label13->setBuddy(answerresp);
  ADJUSTEDIT(answerresp);
  l1->addWidget(label13, row, 1);
  l1->addWidget(answerresp, row++, 2);

  dlpresp = new TQLineEdit(dummyWidget);
  label17 = new TQLabel(i18n("DLP response:"), dummyWidget);
  ADJUSTEDIT(dlpresp);
  l1->addWidget(label17, row, 1);
  l1->addWidget(dlpresp, row++, 2);

  escapestr = new TQLineEdit(dummyWidget);
  label14 = new TQLabel(i18n("Escape strin&g:"), dummyWidget);
  label14->setBuddy(escapestr);
  ADJUSTEDIT(escapestr);
  l1->addWidget(label14, row, 1);
  l1->addWidget(escapestr, row++, 2);

  escaperesp = new TQLineEdit(dummyWidget);
  label15 = new TQLabel(i18n("Escape response:"), dummyWidget);
  ADJUSTEDIT(escaperesp);
  l1->addWidget(label15, row, 1);
  l1->addWidget(escaperesp, row++, 2);

  TQHBoxLayout *l5 = new TQHBoxLayout;
  l1->addLayout(l5, row, 2);
  lslider = new TQLabel("MMMM", dummyWidget);
  FORMATSLIDERLABEL(lslider);

  slider = new TQSlider(0, 255, 1, 0,
				Qt::Horizontal, dummyWidget);
  slider->setFixedHeight(slider->sizeHint().height());
  connect(slider, TQT_SIGNAL(valueChanged(int)),
	  lslider, TQT_SLOT(setNum(int)));
  l5->addWidget(lslider, 0);
  l5->addWidget(slider, 1);

  label16 = new TQLabel(i18n("Guard time (sec/50):"), dummyWidget);
  l1->addWidget(label16, row++, 1);

  TQLabel *l = new TQLabel(i18n("Volume off/low/high:"), dummyWidget);
  l1->addWidget(l, row, 1);
  TQHBoxLayout *l6 = new TQHBoxLayout;
  l1->addLayout(l6, row++, 2);
  volume_off = new TQLineEdit(dummyWidget);
  volume_off->setFixedHeight(volume_off->sizeHint().height());
  volume_off->setMinimumWidth((int)(volume_off->sizeHint().width() / 2));
  volume_medium = new TQLineEdit(dummyWidget);
  volume_medium->setFixedHeight(volume_medium->sizeHint().height());
  volume_medium->setMinimumWidth((int)(volume_medium->sizeHint().width() / 2));
  volume_high = new TQLineEdit(dummyWidget);
  volume_high->setFixedHeight(volume_high->sizeHint().height());
  volume_high->setMinimumWidth((int)(volume_high->sizeHint().width() / 2));
  l6->addWidget(volume_off);
  l6->addWidget(volume_medium);
  l6->addWidget(volume_high);

  initstr[0]->setFocus();

  l1->addColSpacing(0, 10);
  l1->addColSpacing(3, 10);
  l1->addRowSpacing(0, 5);
  l1->addRowSpacing(GRIDROWS, 5);

  //set stuff from gpppdata
  preinitslider->setValue(gpppdata.modemPreInitDelay());
  lpreinitslider->setNum(gpppdata.modemPreInitDelay());
  for(int i = 0; i < PPPData::NumInitStrings; i++)
      initstr[i]->setText(gpppdata.modemInitStr(i));
  initslider->setValue(gpppdata.modemInitDelay());
  linitslider->setNum(gpppdata.modemInitDelay());
  initresp->setText(gpppdata.modemInitResp());

  durationslider->setValue(gpppdata.modemToneDuration());
  ldurationslider->setNum(gpppdata.modemToneDuration());

  nodetectdialtone->setText(gpppdata.modemNoDialToneDetectionStr());
  dialstr->setText(gpppdata.modemDialStr());
  dlpresp->setText(gpppdata.modemDLPResp());

  connectresp->setText(gpppdata.modemConnectResp());
  busyresp->setText(gpppdata.modemBusyResp());
  nocarrierresp->setText(gpppdata.modemNoCarrierResp());
  nodialtoneresp->setText(gpppdata.modemNoDialtoneResp());

  escapestr->setText(gpppdata.modemEscapeStr());
  escaperesp->setText(gpppdata.modemEscapeResp());

  hangupstr->setText(gpppdata.modemHangupStr());
  hangupresp->setText(gpppdata.modemHangupResp());

  answerstr->setText(gpppdata.modemAnswerStr());
  ringresp->setText(gpppdata.modemRingResp());
  answerresp->setText(gpppdata.modemAnswerResp());

  slider->setValue(gpppdata.modemEscapeGuardTime());
  lslider->setNum(gpppdata.modemEscapeGuardTime());

  volume_off->setText(gpppdata.volumeOff());
  volume_medium->setText(gpppdata.volumeMedium());
  volume_high->setText(gpppdata.volumeHigh());
	
	// Save the data, so if it not exist we save the default
	gpppdata.save();
}


void ModemCommands::slotOk() {
  gpppdata.setModemPreInitDelay(lpreinitslider->text().toInt());
  for(int i = 0; i < PPPData::NumInitStrings; i++)
      gpppdata.setModemInitStr(i, initstr[i]->text());
  gpppdata.setModemInitResp(initresp->text());
  gpppdata.setModemInitDelay(linitslider->text().toInt());

  gpppdata.setModemToneDuration(ldurationslider->text().toInt());
  gpppdata.setModemNoDialToneDetectionStr(nodetectdialtone->text());
  gpppdata.setModemDialStr(dialstr->text());
  gpppdata.setModemDLPResp(dlpresp->text());

  gpppdata.setModemConnectResp(connectresp->text());
  gpppdata.setModemBusyResp(busyresp->text());
  gpppdata.setModemNoCarrierResp(nocarrierresp->text());
  gpppdata.setModemNoDialtoneResp(nodialtoneresp->text());

  gpppdata.setModemEscapeStr(escapestr->text());
  gpppdata.setModemEscapeResp(escaperesp->text());
  gpppdata.setModemEscapeGuardTime(lslider->text().toInt());
  gpppdata.setModemHangupStr(hangupstr->text());
  gpppdata.setModemHangupResp(hangupresp->text());

  gpppdata.setModemAnswerStr(answerstr->text());
  gpppdata.setModemRingResp(ringresp->text());
  gpppdata.setModemAnswerResp(answerresp->text());

  gpppdata.setVolumeHigh(volume_high->text());
  gpppdata.setVolumeMedium(volume_medium->text());
  gpppdata.setVolumeOff(volume_off->text());

  gpppdata.save();
  accept();
}


void ModemCommands::slotCancel() {
    //set stuff from gpppdata
  preinitslider->setValue(gpppdata.modemPreInitDelay());
  lpreinitslider->setNum(gpppdata.modemPreInitDelay());
  for(int i = 0; i < PPPData::NumInitStrings; i++)
      initstr[i]->setText(gpppdata.modemInitStr(i));
  initslider->setValue(gpppdata.modemInitDelay());
  linitslider->setNum(gpppdata.modemInitDelay());
  initresp->setText(gpppdata.modemInitResp());

  durationslider->setValue(gpppdata.modemToneDuration());
  ldurationslider->setNum(gpppdata.modemToneDuration());

  nodetectdialtone->setText(gpppdata.modemNoDialToneDetectionStr());
  dialstr->setText(gpppdata.modemDialStr());
  dlpresp->setText(gpppdata.modemDLPResp());

  connectresp->setText(gpppdata.modemConnectResp());
  busyresp->setText(gpppdata.modemBusyResp());
  nocarrierresp->setText(gpppdata.modemNoCarrierResp());
  nodialtoneresp->setText(gpppdata.modemNoDialtoneResp());

  escapestr->setText(gpppdata.modemEscapeStr());
  escaperesp->setText(gpppdata.modemEscapeResp());

  hangupstr->setText(gpppdata.modemHangupStr());
  hangupresp->setText(gpppdata.modemHangupResp());

  answerstr->setText(gpppdata.modemAnswerStr());
  ringresp->setText(gpppdata.modemRingResp());
  answerresp->setText(gpppdata.modemAnswerResp());

  slider->setValue(gpppdata.modemEscapeGuardTime());
  lslider->setNum(gpppdata.modemEscapeGuardTime());

  volume_off->setText(gpppdata.volumeOff());
  volume_medium->setText(gpppdata.volumeMedium());
  volume_high->setText(gpppdata.volumeHigh());
  reject();
}

#include "modemcmds.moc"
