/*
 *
 *            kPPP: A front end for pppd for the KDE project
 *
 * $Id$
 *
 * Copyright (C) 1997 Bernd Johannes Wuebben
 * wuebben@math.cornell.edu
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */


#ifndef _MINITERM_H_
#define _MINITERM_H_

#include <tqdialog.h>
#include <tqpixmap.h>
#include <tqevent.h>
#include <tqmultilineedit.h>
#include <tdetoolbar.h>

class KHelpMenu;

class TQTimer;
class TQMenuBar;
class TDEToolBar;
class KHelpMenu;
class TQPushButton;
class TQLabel;

class MyTerm : public TQMultiLineEdit {
  Q_OBJECT
  
public:
  MyTerm(TQWidget *parent=0, const char *name=0);

  void keyPressEvent (TQKeyEvent*);
  void insertChar(unsigned char c);
  void newLine();
  void backspace();
  void del();
  void myreturn();
  void mynewline();
};


class MiniTerm : public TQDialog {
  Q_OBJECT
  
public:

  MiniTerm(TQWidget *parent=0, const char *name=0);
  ~MiniTerm();

  void closeEvent( TQCloseEvent *e );

public slots:
  void cancelbutton();
  void init();
  void readChar(unsigned char);
  void help();
  void resetModem();

protected:
  void setupToolbar();

  TQPushButton *cancel;
  MyTerm *terminal;
  TQTimer *inittimer;

  TQMenuBar    * menubar;
  TDEToolBar     * toolbar;
  TQPopupMenu  * m_file;
  TQPopupMenu  * m_edit;
  TQPopupMenu  * m_options;
  KHelpMenu  * m_help;
  TQLabel      * statusbar;
  TQPushButton *pb1;
  TQPushButton *pb2;
  TQPushButton *pb3;
  TQPushButton *pb4;

  TQPixmap pb1_pixmap;
  TQPixmap pb2_pixmap;
  TQPixmap pb3_pixmap;
  TQPixmap pb4_pixmap;
};


#endif
