/***************************************************************************
     libwinpopup.h  -  Base class for the WinPopup protocol
                             -------------------
    begin                : Fri Apr 26 2002
    copyright            : (C) 2002 by Gav Wood
    email                : gav@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LIBWINPOPUP_H
#define LIBWINPOPUP_H

//QT includes
#include <tqobject.h>
#include <tqmap.h>
#include <tqstringlist.h>
#include <tqtimer.h>
#include <tqdatetime.h>

// KDE Includes
#include <kprocio.h>
#include <tdefileitem.h>

const TQString WP_POPUP_DIR = TQString::fromLatin1("/var/lib/winpopup");

class KDirLister;

typedef TQMap<TQString, TQString> stringMap;

class WorkGroup
{
	TQStringList groupHosts;

public:
	const TQStringList &Hosts() { return groupHosts; }
	void addHosts(const TQStringList &newHosts) { groupHosts = newHosts; }
};

class WinPopupLib : public TQObject
{
	Q_OBJECT
  

public:
	WinPopupLib(const TQString &smbClient,int groupFreq);
	~WinPopupLib();

	const TQStringList getGroups();
	const TQStringList getHosts(const TQString &Group);
	bool checkHost(const TQString &Name);
	void settingsChanged(const TQString &smbClient, int groupFreq);
	void sendMessage(const TQString &Body, const TQString &Destination);

private:
	bool passedInitialHost;
	TQMap<TQString, WorkGroup> theGroups, currentGroupsMap;
	TQString currentGroup, currentHost;
	TQStringList todo, done, currentHosts;
	stringMap currentGroups;
	TQTimer updateGroupDataTimer;
	TQString smbClientBin;
	int groupCheckFreq;
	KDirLister *dirLister;

	void readMessages(const KFileItemList &items);
	bool checkMessageDir();

private slots:
	void slotUpdateGroupData();
	void startReadProcess(const TQString &Host);
	void slotReadProcessReady(KProcIO *r);
	void slotReadProcessExited(TDEProcess *r);
	void slotSendProcessExited(TDEProcess *p);
	void slotStartDirLister();
	void slotListCompleted();
	void slotNewMessages(const KFileItemList &items);

signals:
	void signalNewMessage(const TQString &, const TQDateTime &, const TQString &);
};

#endif
